<?php

/**
 * Invoice
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.1.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Model;

use ArrayAccess;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * Invoice Class Doc Comment
 *
 * @category Class
 * @description Invoice model
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Invoice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Invoice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dealerId' => 'int',
        'invoiceId' => 'string',
        'invoiceNumber' => 'int',
        'invoiceDate' => 'int',
        'amount' => 'float',
        'amountExclVat' => 'float',
        'vatAmount' => 'float',
        'status' => 'string',
        'dueDate' => 'int',
        'paidStatus' => 'string',
        'invoiceType' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dealerId' => 'int',
        'invoiceId' => 'uuid',
        'invoiceNumber' => 'int64',
        'invoiceDate' => 'int',
        'amount' => 'float',
        'amountExclVat' => 'float',
        'vatAmount' => 'float',
        'status' => null,
        'dueDate' => 'int',
        'paidStatus' => 'string',
        'invoiceType' => 'string'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dealerId' => 'dealer_id',
        'invoiceId' => 'invoice_id',
        'invoiceNumber' => 'invoice_number',
        'invoiceDate' => 'invoice_date',
        'amount' => 'amount',
        'amountExclVat' => 'amount_excl_vat',
        'vatAmount' => 'vat_amount',
        'status' => 'status',
        'dueDate' => 'due_date',
        'paidStatus' => 'paid_status',
        'invoiceType' => 'invoice_type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dealerId' => 'setDealerId',
        'invoiceId' => 'setInvoiceId',
        'invoiceNumber' => 'setInvoiceNumber',
        'invoiceDate' => 'setInvoiceDate',
        'amount' => 'setAmount',
        'amountExclVat' => 'setAmountExclVat',
        'vatAmount' => 'setVatAmount',
        'status' => 'setStatus',
        'dueDate' => 'setDueDate',
        'paidStatus' => 'setPaidStatus',
        'invoiceType' => 'setInvoiceType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dealerId' => 'getDealerId',
        'invoiceId' => 'getInvoiceId',
        'invoiceNumber' => 'getInvoiceNumber',
        'invoiceDate' => 'getInvoiceDate',
        'amount' => 'getAmount',
        'amountExclVat' => 'getAmountExclVat',
        'vatAmount' => 'getVatAmount',
        'status' => 'getStatus',
        'dueDate' => 'getDueDate',
        'paidStatus' => 'getPaidStatus',
        'invoiceType' => 'getInvoiceType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const STATUS_OPEN = 'open';
    public const STATUS_PROCESSED = 'processed';
    public const STATUS_PRINTED = 'printed';
    public const STATUS_DRAFT = 'draft';
    public const PAID_STATUS_DUE = 'due';
    public const PAID_STATUS_PAID = 'paid';
    public const PAID_STATUS_OVERDUE = 'overdue';
    public const INVOICE_TYPE_CREDIT = 'credit';
    public const INVOICE_TYPE_DEBIT = 'debit';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_OPEN,
            self::STATUS_PROCESSED,
            self::STATUS_PRINTED,
            self::STATUS_DRAFT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPaidStatusAllowableValues()
    {
        return [
            self::PAID_STATUS_DUE,
            self::PAID_STATUS_PAID,
            self::PAID_STATUS_OVERDUE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getInvoiceTypeAllowableValues()
    {
        return [
            self::INVOICE_TYPE_CREDIT,
            self::INVOICE_TYPE_DEBIT,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['dealerId'] = $data['dealerId'] ?? null;
        $this->container['invoiceId'] = $data['invoiceId'] ?? null;
        $this->container['invoiceNumber'] = $data['invoiceNumber'] ?? null;
        $this->container['invoiceDate'] = $data['invoiceDate'] ?? null;
        $this->container['amount'] = $data['amount'] ?? null;
        $this->container['amountExclVat'] = $data['amountExclVat'] ?? null;
        $this->container['vatAmount'] = $data['vatAmount'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['dueDate'] = $data['dueDate'] ?? null;
        $this->container['paidStatus'] = $data['paidStatus'] ?? null;
        $this->container['invoiceType'] = $data['invoiceType'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($this->container['status']) && !in_array($this->container['status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'status', must be one of '%s'",
                $this->container['status'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getPaidStatusAllowableValues();
        if (!is_null($this->container['paidStatus']) && !in_array($this->container['paidStatus'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'paidStatus', must be one of '%s'",
                $this->container['paidStatus'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getInvoiceTypeAllowableValues();
        if (!is_null($this->container['invoiceType']) && !in_array($this->container['invoiceType'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'invoiceType', must be one of '%s'",
                $this->container['invoiceType'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dealerId
     *
     * @return int|null
     */
    public function getDealerId()
    {
        return $this->container['dealerId'];
    }

    /**
     * Sets dealerId
     *
     * @param int|null $dealerId ID of the dealer
     *
     * @return self
     */
    public function setDealerId($dealerId)
    {
        $this->container['dealerId'] = $dealerId;

        return $this;
    }

    /**
     * Gets invoiceId
     *
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->container['invoiceId'];
    }

    /**
     * Sets invoiceId
     *
     * @param string|null $invoiceId UUID of the invoice
     *
     * @return self
     */
    public function setInvoiceId($invoiceId)
    {
        $this->container['invoiceId'] = $invoiceId;

        return $this;
    }

    /**
     * Gets invoiceNumber
     *
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoiceNumber'];
    }

    /**
     * Sets invoiceNumber
     *
     * @param int|null $invoiceNumber Invoice number
     *
     * @return self
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->container['invoiceNumber'] = $invoiceNumber;

        return $this;
    }

    /**
     * Gets invoiceDate
     *
     * @return int|null
     */
    public function getInvoiceDate()
    {
        return $this->container['invoiceDate'];
    }

    /**
     * Sets invoiceDate
     *
     * @param int|null $invoiceDate Date of the invoice
     *
     * @return self
     */
    public function setInvoiceDate($invoiceDate)
    {
        $this->container['invoiceDate'] = $invoiceDate;

        return $this;
    }

    /**
     * Gets amount
     *
     * @return float|null
     */
    public function getAmount()
    {
        return $this->container['amount'];
    }

    /**
     * Sets amount
     *
     * @param float|null $amount Amount
     *
     * @return self
     */
    public function setAmount($amount)
    {
        $this->container['amount'] = $amount;

        return $this;
    }

    /**
     * Gets amountExclVat
     *
     * @return float|null
     */
    public function getAmountExclVat()
    {
        return $this->container['amountExclVat'];
    }

    /**
     * Sets amountExclVat
     *
     * @param float|null $amountExclVat Amount excluding VAT
     *
     * @return self
     */
    public function setAmountExclVat($amountExclVat)
    {
        $this->container['amountExclVat'] = $amountExclVat;

        return $this;
    }

    /**
     * Gets vatAmount
     *
     * @return float|null
     */
    public function getVatAmount()
    {
        return $this->container['vatAmount'];
    }

    /**
     * Sets vatAmount
     *
     * @param float|null $vatAmount VAT amount
     *
     * @return self
     */
    public function setVatAmount($vatAmount)
    {
        $this->container['vatAmount'] = $vatAmount;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status invoice status
     *
     * @return self
     */
    public function setStatus($status)
    {
        $allowedValues = $this->getStatusAllowableValues();
        if (!is_null($status) && !in_array($status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'status', must be one of '%s'",
                    $status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets dueDate
     *
     * @return int|null
     */
    public function getDueDate()
    {
        return $this->container['dueDate'];
    }

    /**
     * Sets dueDate
     *
     * @param int|null $dueDate Due date of the invoice
     *
     * @return self
     */
    public function setDueDate($dueDate)
    {
        $this->container['dueDate'] = $dueDate;

        return $this;
    }

    /**
     * Gets paidStatus
     *
     * @return string|null
     */
    public function getPaidStatus()
    {
        return $this->container['paidStatus'];
    }

    /**
     * Sets paidStatus
     *
     * @param string|null $paidStatus Payment status code
     *
     * @return self
     */
    public function setPaidStatus($paidStatus)
    {
        $allowedValues = $this->getPaidStatusAllowableValues();
        if (!is_null($paidStatus) && !in_array($paidStatus, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'paidStatus', must be one of '%s'",
                    $paidStatus,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['paidStatus'] = $paidStatus;

        return $this;
    }

    /**
     * Gets invoiceType
     *
     * @return string|null
     */
    public function getInvoiceType()
    {
        return $this->container['invoiceType'];
    }

    /**
     * Sets invoiceType
     *
     * @param string|null $invoiceType Type of the invoice
     *
     * @return self
     */
    public function setInvoiceType($invoiceType)
    {
        $allowedValues = $this->getInvoiceTypeAllowableValues();
        if (!is_null($invoiceType) && !in_array($invoiceType, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'invoiceType', must be one of '%s'",
                    $invoiceType,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['invoiceType'] = $invoiceType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


