<?php

/**
 * InvoicesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.4.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\HeaderSelector;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * InvoicesApi Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InvoicesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createInvoice' => [
            'multipart/form-data',
        ],
        'finalizeInvoice' => [
            'application/json',
        ],
        'getInvoiceDetails' => [
            'application/json',
        ],
        'getInvoiceList' => [
            'application/json',
        ],
        'getInvoicePDFByID' => [
            'application/json',
        ],
    ];

    /**
         * @param ClientInterface $client
         * @param Configuration   $config
         * @param HeaderSelector  $selector
         * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
         */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createInvoice
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     * @param  string $callgroup Callgroup related to the invoice line (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInvoice'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response|\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response
     */
    public function createInvoice($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null, $callgroup = null, string $contentType = self::contentTypes['createInvoice'][0])
    {
        list($response) = $this->createInvoiceWithHttpInfo($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId, $callgroup, $contentType);
        return $response;
    }

    /**
     * Operation createInvoiceWithHttpInfo
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     * @param  string $callgroup Callgroup related to the invoice line (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInvoice'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response|\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceWithHttpInfo($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null, $callgroup = null, string $contentType = self::contentTypes['createInvoice'][0])
    {
        $request = $this->createInvoiceRequest($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId, $callgroup, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\CreateInvoice400Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAsync
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     * @param  string $callgroup Callgroup related to the invoice line (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsync($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null, $callgroup = null, string $contentType = self::contentTypes['createInvoice'][0])
    {
        return $this->createInvoiceAsyncWithHttpInfo($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId, $callgroup, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAsyncWithHttpInfo
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     * @param  string $callgroup Callgroup related to the invoice line (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsyncWithHttpInfo($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null, $callgroup = null, string $contentType = self::contentTypes['createInvoice'][0])
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\CreateInvoice200Response';
        $request = $this->createInvoiceRequest($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId, $callgroup, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoice'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     * @param  string $callgroup Callgroup related to the invoice line (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoiceRequest($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null, $callgroup = null, string $contentType = self::contentTypes['createInvoice'][0])
    {

        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling createInvoice'
            );
        }

        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling createInvoice'
            );
        }





        if ($constructionYear !== null && !preg_match("/^\\d{4}$/", $constructionYear)) {
            throw new \InvalidArgumentException("invalid value for \"constructionYear\" when calling InvoicesApi.createInvoice, must conform to the pattern /^\\d{4}$/.");
        }








        $resourcePath = '/api/{country}/{vehicleType}/invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }

        // form params
        if ($lotId !== null) {
            $formParams['lot_id'] = ObjectSerializer::toFormValue($lotId);
        }
        // form params
        if ($unitPrice !== null) {
            $formParams['unit_price'] = ObjectSerializer::toFormValue($unitPrice);
        }
        // form params
        if ($quantity !== null) {
            $formParams['quantity'] = ObjectSerializer::toFormValue($quantity);
        }
        // form params
        if ($licensePlate !== null) {
            $formParams['license_plate'] = ObjectSerializer::toFormValue($licensePlate);
        }
        // form params
        if ($constructionYear !== null) {
            $formParams['construction_year'] = ObjectSerializer::toFormValue($constructionYear);
        }
        // form params
        if ($make !== null) {
            $formParams['make'] = ObjectSerializer::toFormValue($make);
        }
        // form params
        if ($model !== null) {
            $formParams['model'] = ObjectSerializer::toFormValue($model);
        }
        // form params
        if ($makeAndModel !== null) {
            $formParams['make_and_model'] = ObjectSerializer::toFormValue($makeAndModel);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = ObjectSerializer::toFormValue($description);
        }
        // form params
        if ($dealerId !== null) {
            $formParams['dealer_id'] = ObjectSerializer::toFormValue($dealerId);
        }
        // form params
        if ($callgroup !== null) {
            $formParams['callgroup'] = ObjectSerializer::toFormValue($callgroup);
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );
        if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
            // Content type requires multipart
            $multipart = true;
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', ],
                $contentType,
                true,
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation finalizeInvoice
     *
     * Finalize the invoice
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  string $invoiceProviderId invoiceProviderId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finalizeInvoice'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function finalizeInvoice($country, $vehicleType, $invoiceProviderId, string $contentType = self::contentTypes['finalizeInvoice'][0])
    {
        $this->finalizeInvoiceWithHttpInfo($country, $vehicleType, $invoiceProviderId, $contentType);
    }

    /**
     * Operation finalizeInvoiceWithHttpInfo
     *
     * Finalize the invoice
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finalizeInvoice'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function finalizeInvoiceWithHttpInfo($country, $vehicleType, $invoiceProviderId, string $contentType = self::contentTypes['finalizeInvoice'][0])
    {
        $request = $this->finalizeInvoiceRequest($country, $vehicleType, $invoiceProviderId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation finalizeInvoiceAsync
     *
     * Finalize the invoice
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finalizeInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function finalizeInvoiceAsync($country, $vehicleType, $invoiceProviderId, string $contentType = self::contentTypes['finalizeInvoice'][0])
    {
        return $this->finalizeInvoiceAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation finalizeInvoiceAsyncWithHttpInfo
     *
     * Finalize the invoice
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finalizeInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function finalizeInvoiceAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, string $contentType = self::contentTypes['finalizeInvoice'][0])
    {
        $returnType = '';
        $request = $this->finalizeInvoiceRequest($country, $vehicleType, $invoiceProviderId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'finalizeInvoice'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['finalizeInvoice'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function finalizeInvoiceRequest($country, $vehicleType, $invoiceProviderId, string $contentType = self::contentTypes['finalizeInvoice'][0])
    {

        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling finalizeInvoice'
            );
        }

        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling finalizeInvoice'
            );
        }

        // verify the required parameter 'invoiceProviderId' is set
        if ($invoiceProviderId === null || (is_array($invoiceProviderId) && count($invoiceProviderId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoiceProviderId when calling finalizeInvoice'
            );
        }


        $resourcePath = '/api/{country}/{vehicleType}/invoices/{invoiceProviderId}/finalize';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }
        // path params
        if ($invoiceProviderId !== null) {
            $resourcePath = str_replace(
                '{' . 'invoiceProviderId' . '}',
                ObjectSerializer::toPathValue($invoiceProviderId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );
        if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
            // Content type requires multipart
            $multipart = true;
            $headers = $this->headerSelector->selectHeaders(
                [],
                $contentType,
                true,
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoiceDetails
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  string $invoiceProviderId invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceDetails'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\Invoice[]
     */
    public function getInvoiceDetails($country, $vehicleType, $invoiceProviderId, $dealerId, string $contentType = self::contentTypes['getInvoiceDetails'][0])
    {
        list($response) = $this->getInvoiceDetailsWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);
        return $response;
    }

    /**
     * Operation getInvoiceDetailsWithHttpInfo
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceDetails'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\Invoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceDetailsWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, string $contentType = self::contentTypes['getInvoiceDetails'][0])
    {
        $request = $this->getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\Invoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\Invoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoiceDetailsAsync
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceDetailsAsync($country, $vehicleType, $invoiceProviderId, $dealerId, string $contentType = self::contentTypes['getInvoiceDetails'][0])
    {
        return $this->getInvoiceDetailsAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoiceDetailsAsyncWithHttpInfo
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceDetailsAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, string $contentType = self::contentTypes['getInvoiceDetails'][0])
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
        $request = $this->getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoiceDetails'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceDetails'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId, string $contentType = self::contentTypes['getInvoiceDetails'][0])
    {

        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoiceDetails'
            );
        }

        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoiceDetails'
            );
        }

        // verify the required parameter 'invoiceProviderId' is set
        if ($invoiceProviderId === null || (is_array($invoiceProviderId) && count($invoiceProviderId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoiceProviderId when calling getInvoiceDetails'
            );
        }

        // verify the required parameter 'dealerId' is set
        if ($dealerId === null || (is_array($dealerId) && count($dealerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dealerId when calling getInvoiceDetails'
            );
        }


        $resourcePath = '/api/{country}/{vehicleType}/invoices/{invoiceProviderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dealerId,
            'dealer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }
        // path params
        if ($invoiceProviderId !== null) {
            $resourcePath = str_replace(
                '{' . 'invoiceProviderId' . '}',
                ObjectSerializer::toPathValue($invoiceProviderId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );
        if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
            // Content type requires multipart
            $multipart = true;
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', ],
                $contentType,
                true,
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoiceList
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     * @param  int $lotId Filter invoices on provided lot id (optional)
     * @param  Datetime $invoicedAt Filter invoices on provided invoice status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceList'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\Invoice[]
     */
    public function getInvoiceList($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null, $lotId = null, $invoicedAt = null, string $contentType = self::contentTypes['getInvoiceList'][0])
    {
        list($response) = $this->getInvoiceListWithHttpInfo($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus, $lotId, $invoicedAt, $contentType);
        return $response;
    }

    /**
     * Operation getInvoiceListWithHttpInfo
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     * @param  int $lotId Filter invoices on provided lot id (optional)
     * @param  Datetime $invoicedAt Filter invoices on provided invoice status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceList'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\Invoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceListWithHttpInfo($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null, $lotId = null, $invoicedAt = null, string $contentType = self::contentTypes['getInvoiceList'][0])
    {
        $request = $this->getInvoiceListRequest($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus, $lotId, $invoicedAt, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\Invoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\Invoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoiceListAsync
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     * @param  int $lotId Filter invoices on provided lot id (optional)
     * @param  Datetime $invoicedAt Filter invoices on provided invoice status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceListAsync($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null, $lotId = null, $invoicedAt = null, string $contentType = self::contentTypes['getInvoiceList'][0])
    {
        return $this->getInvoiceListAsyncWithHttpInfo($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus, $lotId, $invoicedAt, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoiceListAsyncWithHttpInfo
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     * @param  int $lotId Filter invoices on provided lot id (optional)
     * @param  Datetime $invoicedAt Filter invoices on provided invoice status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceListAsyncWithHttpInfo($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null, $lotId = null, $invoicedAt = null, string $contentType = self::contentTypes['getInvoiceList'][0])
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
        $request = $this->getInvoiceListRequest($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus, $lotId, $invoicedAt, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoiceList'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     * @param  int $lotId Filter invoices on provided lot id (optional)
     * @param  Datetime $invoicedAt Filter invoices on provided invoice status (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoiceList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoiceListRequest($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null, $lotId = null, $invoicedAt = null, string $contentType = self::contentTypes['getInvoiceList'][0])
    {

        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoiceList'
            );
        }

        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoiceList'
            );
        }









        $resourcePath = '/api/{country}/{vehicleType}/invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $year,
            'year', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $paidStatus,
            'paid_status', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoiceType,
            'invoice_type', // param base name
            'array', // openApiType
            'form', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dealerId,
            'dealer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoiceStatus,
            'invoice_status', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $lotId,
            'lot_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $invoicedAt,
            'invoiced_at', // param base name
            'datetime', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );
        if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
            // Content type requires multipart
            $multipart = true;
            $headers = $this->headerSelector->selectHeaders(
                ['application/json', ],
                $contentType,
                true,
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoicePDFByID
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  string $invoiceProviderId invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoicePDFByID'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getInvoicePDFByID($country, $vehicleType, $invoiceProviderId, $dealerId = null, string $contentType = self::contentTypes['getInvoicePDFByID'][0])
    {
        list($response) = $this->getInvoicePDFByIDWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);
        return $response;
    }

    /**
     * Operation getInvoicePDFByIDWithHttpInfo
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoicePDFByID'] to see the possible values for this operation
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoicePDFByIDWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId = null, string $contentType = self::contentTypes['getInvoicePDFByID'][0])
    {
        $request = $this->getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SplFileObject' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoicePDFByIDAsync
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoicePDFByID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoicePDFByIDAsync($country, $vehicleType, $invoiceProviderId, $dealerId = null, string $contentType = self::contentTypes['getInvoicePDFByID'][0])
    {
        return $this->getInvoicePDFByIDAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoicePDFByIDAsyncWithHttpInfo
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoicePDFByID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoicePDFByIDAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId = null, string $contentType = self::contentTypes['getInvoicePDFByID'][0])
    {
        $returnType = '\SplFileObject';
        $request = $this->getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoicePDFByID'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInvoicePDFByID'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId = null, string $contentType = self::contentTypes['getInvoicePDFByID'][0])
    {

        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoicePDFByID'
            );
        }

        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoicePDFByID'
            );
        }

        // verify the required parameter 'invoiceProviderId' is set
        if ($invoiceProviderId === null || (is_array($invoiceProviderId) && count($invoiceProviderId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoiceProviderId when calling getInvoicePDFByID'
            );
        }



        $resourcePath = '/api/{country}/{vehicleType}/invoices/{invoiceProviderId}/pdf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dealerId,
            'dealer_id', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }
        // path params
        if ($invoiceProviderId !== null) {
            $resourcePath = str_replace(
                '{' . 'invoiceProviderId' . '}',
                ObjectSerializer::toPathValue($invoiceProviderId),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/pdf', ],
            $contentType,
            $multipart
        );
        if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
            // Content type requires multipart
            $multipart = true;
            $headers = $this->headerSelector->selectHeaders(
                ['application/pdf', ],
                $contentType,
                true,
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
