<?php

/**
 * Debtor
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.4.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Model;

use ArrayAccess;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * Debtor Class Doc Comment
 *
 * @category Class
 * @description Debtor model
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Debtor implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Debtor';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dealerId' => 'int',
        'activeDealer' => 'bool',
        'name' => 'string',
        'countryCode' => 'string',
        'province' => 'string',
        'city' => 'string',
        'address' => 'string',
        'postalCode' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'vatNumber' => 'string',
        'cocNumber' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dealerId' => 'int64',
        'activeDealer' => 'bool',
        'name' => 'string',
        'countryCode' => 'string',
        'province' => 'string',
        'city' => 'string',
        'address' => 'string',
        'postalCode' => 'string',
        'email' => 'email',
        'phone' => 'string',
        'vatNumber' => 'vatnr',
        'cocNumber' => 'string'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'dealerId' => false,
        'activeDealer' => false,
        'name' => false,
        'countryCode' => false,
        'province' => false,
        'city' => false,
        'address' => false,
        'postalCode' => false,
        'email' => false,
        'phone' => false,
        'vatNumber' => false,
        'cocNumber' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dealerId' => 'dealer_id',
        'activeDealer' => 'active_dealer',
        'name' => 'name',
        'countryCode' => 'country_code',
        'province' => 'province',
        'city' => 'city',
        'address' => 'address',
        'postalCode' => 'postal_code',
        'email' => 'email',
        'phone' => 'phone',
        'vatNumber' => 'vat_number',
        'cocNumber' => 'coc_number'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dealerId' => 'setDealerId',
        'activeDealer' => 'setActiveDealer',
        'name' => 'setName',
        'countryCode' => 'setCountryCode',
        'province' => 'setProvince',
        'city' => 'setCity',
        'address' => 'setAddress',
        'postalCode' => 'setPostalCode',
        'email' => 'setEmail',
        'phone' => 'setPhone',
        'vatNumber' => 'setVatNumber',
        'cocNumber' => 'setCocNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dealerId' => 'getDealerId',
        'activeDealer' => 'getActiveDealer',
        'name' => 'getName',
        'countryCode' => 'getCountryCode',
        'province' => 'getProvince',
        'city' => 'getCity',
        'address' => 'getAddress',
        'postalCode' => 'getPostalCode',
        'email' => 'getEmail',
        'phone' => 'getPhone',
        'vatNumber' => 'getVatNumber',
        'cocNumber' => 'getCocNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('dealerId', $data ?? [], null);
        $this->setIfExists('activeDealer', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('countryCode', $data ?? [], null);
        $this->setIfExists('province', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('postalCode', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('phone', $data ?? [], null);
        $this->setIfExists('vatNumber', $data ?? [], null);
        $this->setIfExists('cocNumber', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['countryCode']) && (mb_strlen($this->container['countryCode']) > 2)) {
            $invalidProperties[] = "invalid value for 'countryCode', the character length must be smaller than or equal to 2.";
        }

        if (!is_null($this->container['countryCode']) && (mb_strlen($this->container['countryCode']) < 2)) {
            $invalidProperties[] = "invalid value for 'countryCode', the character length must be bigger than or equal to 2.";
        }

        if (!is_null($this->container['phone']) && !preg_match("/\\+[1-9][0-9]{4,}/", $this->container['phone'])) {
            $invalidProperties[] = "invalid value for 'phone', must be conform to the pattern /\\+[1-9][0-9]{4,}/.";
        }

        if (!is_null($this->container['vatNumber']) && !preg_match("/^[A-Z]{2}.+$/", $this->container['vatNumber'])) {
            $invalidProperties[] = "invalid value for 'vatNumber', must be conform to the pattern /^[A-Z]{2}.+$/.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dealerId
     *
     * @return int|null
     */
    public function getDealerId()
    {
        return $this->container['dealerId'];
    }

    /**
     * Sets dealerId
     *
     * @param int|null $dealerId ID of the dealer
     *
     * @return self
     */
    public function setDealerId($dealerId)
    {
        if (is_null($dealerId)) {
            throw new \InvalidArgumentException('non-nullable dealerId cannot be null');
        }
        $this->container['dealerId'] = $dealerId;

        return $this;
    }

    /**
     * Gets activeDealer
     *
     * @return bool|null
     */
    public function getActiveDealer()
    {
        return $this->container['activeDealer'];
    }

    /**
     * Sets activeDealer
     *
     * @param bool|null $activeDealer is the dealer active
     *
     * @return self
     */
    public function setActiveDealer($activeDealer)
    {
        if (is_null($activeDealer)) {
            throw new \InvalidArgumentException('non-nullable activeDealer cannot be null');
        }
        $this->container['activeDealer'] = $activeDealer;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name dealer name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets countryCode
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     *
     * @param string|null $countryCode Country code
     *
     * @return self
     */
    public function setCountryCode($countryCode)
    {
        if (is_null($countryCode)) {
            throw new \InvalidArgumentException('non-nullable countryCode cannot be null');
        }
        if ((mb_strlen($countryCode) > 2)) {
            throw new \InvalidArgumentException('invalid length for $countryCode when calling Debtor., must be smaller than or equal to 2.');
        }
        if ((mb_strlen($countryCode) < 2)) {
            throw new \InvalidArgumentException('invalid length for $countryCode when calling Debtor., must be bigger than or equal to 2.');
        }

        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets province
     *
     * @return string|null
     */
    public function getProvince()
    {
        return $this->container['province'];
    }

    /**
     * Sets province
     *
     * @param string|null $province province where the dealer is located
     *
     * @return self
     */
    public function setProvince($province)
    {
        if (is_null($province)) {
            throw new \InvalidArgumentException('non-nullable province cannot be null');
        }
        $this->container['province'] = $province;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city where the dealer is locatied
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            throw new \InvalidArgumentException('non-nullable city cannot be null');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string|null $address street housenumber where the dealer is locatied
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets postalCode
     *
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->container['postalCode'];
    }

    /**
     * Sets postalCode
     *
     * @param string|null $postalCode postcal code where the dealer is locatied
     *
     * @return self
     */
    public function setPostalCode($postalCode)
    {
        if (is_null($postalCode)) {
            throw new \InvalidArgumentException('non-nullable postalCode cannot be null');
        }
        $this->container['postalCode'] = $postalCode;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email adres where the dealer will get their invoices
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone phonenumber of dealer for financial issues
     *
     * @return self
     */
    public function setPhone($phone)
    {
        if (is_null($phone)) {
            throw new \InvalidArgumentException('non-nullable phone cannot be null');
        }

        if ((!preg_match("/\\+[1-9][0-9]{4,}/", ObjectSerializer::toString($phone)))) {
            throw new \InvalidArgumentException("invalid value for \$phone when calling Debtor., must conform to the pattern /\\+[1-9][0-9]{4,}/.");
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets vatNumber
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vatNumber'];
    }

    /**
     * Sets vatNumber
     *
     * @param string|null $vatNumber VAT number for the dealer
     *
     * @return self
     */
    public function setVatNumber($vatNumber)
    {
        if (is_null($vatNumber)) {
            throw new \InvalidArgumentException('non-nullable vatNumber cannot be null');
        }

        if ((!preg_match("/^[A-Z]{2}.+$/", ObjectSerializer::toString($vatNumber)))) {
            throw new \InvalidArgumentException("invalid value for \$vatNumber when calling Debtor., must conform to the pattern /^[A-Z]{2}.+$/.");
        }

        $this->container['vatNumber'] = $vatNumber;

        return $this;
    }

    /**
     * Gets cocNumber
     *
     * @return string|null
     */
    public function getCocNumber()
    {
        return $this->container['cocNumber'];
    }

    /**
     * Sets cocNumber
     *
     * @param string|null $cocNumber Chamber Of Commerce nr
     *
     * @return self
     */
    public function setCocNumber($cocNumber)
    {
        if (is_null($cocNumber)) {
            throw new \InvalidArgumentException('non-nullable cocNumber cannot be null');
        }
        $this->container['cocNumber'] = $cocNumber;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


