<?php

/**
 * Debtor
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Model;

use ArrayAccess;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * Debtor Class Doc Comment
 *
 * @category Class
 * @description Debtor model
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Debtor implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Debtor';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'dealerId' => 'int',
        'activeDealer' => 'bool',
        'name' => 'string',
        'countryCode' => 'string',
        'province' => 'string',
        'city' => 'string',
        'address' => 'string',
        'postalCode' => 'string',
        'email' => 'string',
        'phone' => 'string',
        'vatNumber' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'dealerId' => 'int64',
        'activeDealer' => 'bool',
        'name' => 'string',
        'countryCode' => 'string',
        'province' => 'string',
        'city' => 'string',
        'address' => 'string',
        'postalCode' => 'string',
        'email' => 'email',
        'phone' => 'string',
        'vatNumber' => 'vatnr'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'dealerId' => 'dealer_id',
        'activeDealer' => 'active_dealer',
        'name' => 'name',
        'countryCode' => 'country_code',
        'province' => 'province',
        'city' => 'city',
        'address' => 'address',
        'postalCode' => 'postal_code',
        'email' => 'email',
        'phone' => 'phone',
        'vatNumber' => 'vat_number'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'dealerId' => 'setDealerId',
        'activeDealer' => 'setActiveDealer',
        'name' => 'setName',
        'countryCode' => 'setCountryCode',
        'province' => 'setProvince',
        'city' => 'setCity',
        'address' => 'setAddress',
        'postalCode' => 'setPostalCode',
        'email' => 'setEmail',
        'phone' => 'setPhone',
        'vatNumber' => 'setVatNumber'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'dealerId' => 'getDealerId',
        'activeDealer' => 'getActiveDealer',
        'name' => 'getName',
        'countryCode' => 'getCountryCode',
        'province' => 'getProvince',
        'city' => 'getCity',
        'address' => 'getAddress',
        'postalCode' => 'getPostalCode',
        'email' => 'getEmail',
        'phone' => 'getPhone',
        'vatNumber' => 'getVatNumber'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['dealerId'] = $data['dealerId'] ?? null;
        $this->container['activeDealer'] = $data['activeDealer'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['countryCode'] = $data['countryCode'] ?? null;
        $this->container['province'] = $data['province'] ?? null;
        $this->container['city'] = $data['city'] ?? null;
        $this->container['address'] = $data['address'] ?? null;
        $this->container['postalCode'] = $data['postalCode'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['phone'] = $data['phone'] ?? null;
        $this->container['vatNumber'] = $data['vatNumber'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['countryCode']) && (mb_strlen($this->container['countryCode']) > 2)) {
            $invalidProperties[] = "invalid value for 'countryCode', the character length must be smaller than or equal to 2.";
        }

        if (!is_null($this->container['countryCode']) && (mb_strlen($this->container['countryCode']) < 2)) {
            $invalidProperties[] = "invalid value for 'countryCode', the character length must be bigger than or equal to 2.";
        }

        if (!is_null($this->container['phone']) && !preg_match("/\\+[1-9][0-9]{4,}/", $this->container['phone'])) {
            $invalidProperties[] = "invalid value for 'phone', must be conform to the pattern /\\+[1-9][0-9]{4,}/.";
        }

        if (!is_null($this->container['vatNumber']) && !preg_match("/^[A-Z]{2}.+$/", $this->container['vatNumber'])) {
            $invalidProperties[] = "invalid value for 'vatNumber', must be conform to the pattern /^[A-Z]{2}.+$/.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets dealerId
     *
     * @return int|null
     */
    public function getDealerId()
    {
        return $this->container['dealerId'];
    }

    /**
     * Sets dealerId
     *
     * @param int|null $dealerId ID of the dealer
     *
     * @return self
     */
    public function setDealerId($dealerId)
    {
        $this->container['dealerId'] = $dealerId;

        return $this;
    }

    /**
     * Gets activeDealer
     *
     * @return bool|null
     */
    public function getActiveDealer()
    {
        return $this->container['activeDealer'];
    }

    /**
     * Sets activeDealer
     *
     * @param bool|null $activeDealer is the dealer active
     *
     * @return self
     */
    public function setActiveDealer($activeDealer)
    {
        $this->container['activeDealer'] = $activeDealer;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name dealer name
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets countryCode
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['countryCode'];
    }

    /**
     * Sets countryCode
     *
     * @param string|null $countryCode Country code
     *
     * @return self
     */
    public function setCountryCode($countryCode)
    {
        if (!is_null($countryCode) && (mb_strlen($countryCode) > 2)) {
            throw new \InvalidArgumentException('invalid length for $countryCode when calling Debtor., must be smaller than or equal to 2.');
        }
        if (!is_null($countryCode) && (mb_strlen($countryCode) < 2)) {
            throw new \InvalidArgumentException('invalid length for $countryCode when calling Debtor., must be bigger than or equal to 2.');
        }

        $this->container['countryCode'] = $countryCode;

        return $this;
    }

    /**
     * Gets province
     *
     * @return string|null
     */
    public function getProvince()
    {
        return $this->container['province'];
    }

    /**
     * Sets province
     *
     * @param string|null $province province where the dealer is located
     *
     * @return self
     */
    public function setProvince($province)
    {
        $this->container['province'] = $province;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city where the dealer is locatied
     *
     * @return self
     */
    public function setCity($city)
    {
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string|null $address street housenumber where the dealer is locatied
     *
     * @return self
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets postalCode
     *
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->container['postalCode'];
    }

    /**
     * Sets postalCode
     *
     * @param string|null $postalCode postcal code where the dealer is locatied
     *
     * @return self
     */
    public function setPostalCode($postalCode)
    {
        $this->container['postalCode'] = $postalCode;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email adres where the dealer will get their invoices
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone phonenumber of dealer for financial issues
     *
     * @return self
     */
    public function setPhone($phone)
    {

        if (!is_null($phone) && (!preg_match("/\\+[1-9][0-9]{4,}/", $phone))) {
            throw new \InvalidArgumentException("invalid value for $phone when calling Debtor., must conform to the pattern /\\+[1-9][0-9]{4,}/.");
        }

        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets vatNumber
     *
     * @return string|null
     */
    public function getVatNumber()
    {
        return $this->container['vatNumber'];
    }

    /**
     * Sets vatNumber
     *
     * @param string|null $vatNumber VAT number for the dealer
     *
     * @return self
     */
    public function setVatNumber($vatNumber)
    {

        if (!is_null($vatNumber) && (!preg_match("/^[A-Z]{2}.+$/", $vatNumber))) {
            throw new \InvalidArgumentException("invalid value for $vatNumber when calling Debtor., must conform to the pattern /^[A-Z]{2}.+$/.");
        }

        $this->container['vatNumber'] = $vatNumber;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


