<?php

/**
 * InvoiceLine
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.3.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Model;

use ArrayAccess;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * InvoiceLine Class Doc Comment
 *
 * @category Class
 * @description InvoiceLine model
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class InvoiceLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InvoiceLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'lotId' => 'int',
        'unitPrice' => 'int',
        'quantity' => 'int',
        'licensePlate' => 'string',
        'constructionYear' => 'string',
        'make' => 'string',
        'model' => 'string',
        'makeAndModel' => 'string',
        'description' => 'string',
        'dealerId' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'lotId' => 'int64',
        'unitPrice' => 'int',
        'quantity' => 'int',
        'licensePlate' => null,
        'constructionYear' => null,
        'make' => null,
        'model' => null,
        'makeAndModel' => null,
        'description' => null,
        'dealerId' => 'int64'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'lotId' => 'lot_id',
        'unitPrice' => 'unit_price',
        'quantity' => 'quantity',
        'licensePlate' => 'license_plate',
        'constructionYear' => 'construction_year',
        'make' => 'make',
        'model' => 'model',
        'makeAndModel' => 'make_and_model',
        'description' => 'description',
        'dealerId' => 'dealer_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'lotId' => 'setLotId',
        'unitPrice' => 'setUnitPrice',
        'quantity' => 'setQuantity',
        'licensePlate' => 'setLicensePlate',
        'constructionYear' => 'setConstructionYear',
        'make' => 'setMake',
        'model' => 'setModel',
        'makeAndModel' => 'setMakeAndModel',
        'description' => 'setDescription',
        'dealerId' => 'setDealerId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'lotId' => 'getLotId',
        'unitPrice' => 'getUnitPrice',
        'quantity' => 'getQuantity',
        'licensePlate' => 'getLicensePlate',
        'constructionYear' => 'getConstructionYear',
        'make' => 'getMake',
        'model' => 'getModel',
        'makeAndModel' => 'getMakeAndModel',
        'description' => 'getDescription',
        'dealerId' => 'getDealerId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['lotId'] = $data['lotId'] ?? null;
        $this->container['unitPrice'] = $data['unitPrice'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['licensePlate'] = $data['licensePlate'] ?? null;
        $this->container['constructionYear'] = $data['constructionYear'] ?? null;
        $this->container['make'] = $data['make'] ?? null;
        $this->container['model'] = $data['model'] ?? null;
        $this->container['makeAndModel'] = $data['makeAndModel'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['dealerId'] = $data['dealerId'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['constructionYear']) && !preg_match("/^\\d{4}$/", $this->container['constructionYear'])) {
            $invalidProperties[] = "invalid value for 'constructionYear', must be conform to the pattern /^\\d{4}$/.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets lotId
     *
     * @return int|null
     */
    public function getLotId()
    {
        return $this->container['lotId'];
    }

    /**
     * Sets lotId
     *
     * @param int|null $lotId Id of the lot sold
     *
     * @return self
     */
    public function setLotId($lotId)
    {
        $this->container['lotId'] = $lotId;

        return $this;
    }

    /**
     * Gets unitPrice
     *
     * @return int|null
     */
    public function getUnitPrice()
    {
        return $this->container['unitPrice'];
    }

    /**
     * Sets unitPrice
     *
     * @param int|null $unitPrice Price of the unit aka fee
     *
     * @return self
     */
    public function setUnitPrice($unitPrice)
    {
        $this->container['unitPrice'] = $unitPrice;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets licensePlate
     *
     * @return string|null
     */
    public function getLicensePlate()
    {
        return $this->container['licensePlate'];
    }

    /**
     * Sets licensePlate
     *
     * @param string|null $licensePlate License plate
     *
     * @return self
     */
    public function setLicensePlate($licensePlate)
    {
        $this->container['licensePlate'] = $licensePlate;

        return $this;
    }

    /**
     * Gets constructionYear
     *
     * @return string|null
     */
    public function getConstructionYear()
    {
        return $this->container['constructionYear'];
    }

    /**
     * Sets constructionYear
     *
     * @param string|null $constructionYear Construction year
     *
     * @return self
     */
    public function setConstructionYear($constructionYear)
    {

        if (!is_null($constructionYear) && (!preg_match("/^\\d{4}$/", $constructionYear))) {
            throw new \InvalidArgumentException("invalid value for $constructionYear when calling InvoiceLine., must conform to the pattern /^\\d{4}$/.");
        }

        $this->container['constructionYear'] = $constructionYear;

        return $this;
    }

    /**
     * Gets make
     *
     * @return string|null
     */
    public function getMake()
    {
        return $this->container['make'];
    }

    /**
     * Sets make
     *
     * @param string|null $make Make
     *
     * @return self
     */
    public function setMake($make)
    {
        $this->container['make'] = $make;

        return $this;
    }

    /**
     * Gets model
     *
     * @return string|null
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     *
     * @param string|null $model model
     *
     * @return self
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets makeAndModel
     *
     * @return string|null
     */
    public function getMakeAndModel()
    {
        return $this->container['makeAndModel'];
    }

    /**
     * Sets makeAndModel
     *
     * @param string|null $makeAndModel Make and model
     *
     * @return self
     */
    public function setMakeAndModel($makeAndModel)
    {
        $this->container['makeAndModel'] = $makeAndModel;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description General description for invoice line
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets dealerId
     *
     * @return int|null
     */
    public function getDealerId()
    {
        return $this->container['dealerId'];
    }

    /**
     * Sets dealerId
     *
     * @param int|null $dealerId Id of the dealer buying the lot
     *
     * @return self
     */
    public function setDealerId($dealerId)
    {
        $this->container['dealerId'] = $dealerId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


