# Dealerdirect\FinanceApiClient\DebtorsApi

Client to communicate with the Dealerdirect Finance-API

All URIs are relative to http://localhost.

Method | HTTP request | Description
------------- | ------------- | -------------
[**updateDebtors()**](DebtorsApi.md#updateDebtors) | **POST** /api/{country}/{vehicleType}/debtors/update | Update debtor information


## `updateDebtors()`

```php
updateDebtors($country, $vehicleType, $debtor, $keepCache)
```

Update debtor information

Update debtor information, updates debtors and create debtors which do not exists yet.      *               Debtors will never be deleted

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\DebtorsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$debtor = array(new \Dealerdirect\FinanceApiClient\Model\Debtor()); // \Dealerdirect\FinanceApiClient\Model\Debtor[] | Debtors
$keepCache = true; // bool | Keep cache

try {
    $apiInstance->updateDebtors($country, $vehicleType, $debtor, $keepCache);
} catch (Exception $e) {
    echo 'Exception when calling DebtorsApi->updateDebtors: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **debtor** | [**\Dealerdirect\FinanceApiClient\Model\Debtor[]**](../Model/Debtor.md)| Debtors |
 **keepCache** | **bool**| Keep cache | [optional] [default to false]

### Return type

void (empty response body)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
