<?php

/**
 * DebtorsApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.1.1-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\HeaderSelector;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * DebtorsApi Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class DebtorsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation updateDebtors
     *
     * Update debtor information
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  \Dealerdirect\FinanceApiClient\Model\Debtor[] $debtor Debtors (required)
     * @param  bool $keepCache Keep cache (optional, default to false)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateDebtors($country, $vehicleType, $debtor, $keepCache = false)
    {
        $this->updateDebtorsWithHttpInfo($country, $vehicleType, $debtor, $keepCache);
    }

    /**
     * Operation updateDebtorsWithHttpInfo
     *
     * Update debtor information
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  \Dealerdirect\FinanceApiClient\Model\Debtor[] $debtor Debtors (required)
     * @param  bool $keepCache Keep cache (optional, default to false)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDebtorsWithHttpInfo($country, $vehicleType, $debtor, $keepCache = false)
    {
        $request = $this->updateDebtorsRequest($country, $vehicleType, $debtor, $keepCache);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateDebtorsAsync
     *
     * Update debtor information
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  \Dealerdirect\FinanceApiClient\Model\Debtor[] $debtor Debtors (required)
     * @param  bool $keepCache Keep cache (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDebtorsAsync($country, $vehicleType, $debtor, $keepCache = false)
    {
        return $this->updateDebtorsAsyncWithHttpInfo($country, $vehicleType, $debtor, $keepCache)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateDebtorsAsyncWithHttpInfo
     *
     * Update debtor information
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  \Dealerdirect\FinanceApiClient\Model\Debtor[] $debtor Debtors (required)
     * @param  bool $keepCache Keep cache (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateDebtorsAsyncWithHttpInfo($country, $vehicleType, $debtor, $keepCache = false)
    {
        $returnType = '';
        $request = $this->updateDebtorsRequest($country, $vehicleType, $debtor, $keepCache);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateDebtors'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  \Dealerdirect\FinanceApiClient\Model\Debtor[] $debtor Debtors (required)
     * @param  bool $keepCache Keep cache (optional, default to false)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateDebtorsRequest($country, $vehicleType, $debtor, $keepCache = false)
    {
        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling updateDebtors'
            );
        }
        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling updateDebtors'
            );
        }
        // verify the required parameter 'debtor' is set
        if ($debtor === null || (is_array($debtor) && count($debtor) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $debtor when calling updateDebtors'
            );
        }

        $resourcePath = '/api/{country}/{vehicleType}/debtors/update';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($keepCache !== null) {
            if ('form' === 'form' && is_array($keepCache)) {
                foreach ($keepCache as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['keepCache'] = $keepCache;
            }
        }


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($debtor)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($debtor));
            } else {
                $httpBody = $debtor;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
