# Dealerdirect\FinanceApiClient\InvoicesApi

Client to communicate with the Dealerdirect Finance-API

All URIs are relative to http://localhost.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createInvoice()**](InvoicesApi.md#createInvoice) | **POST** /api/{country}/{vehicleType}/invoice | create an invoice(line)
[**getInvoiceListByDealer()**](InvoicesApi.md#getInvoiceListByDealer) | **GET** /api/{country}/{vehicleType}/invoice/{dealerId} | get invoices of dealer
[**getInvoicePDFByID()**](InvoicesApi.md#getInvoicePDFByID) | **GET** /api/{country}/{vehicleType}/invoice/{dealerId}/{invoiceNumber}/pdf | Get a invoice in PDF


## `createInvoice()`

```php
createInvoice($country, $vehicleType, $dealerId, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model)
```

create an invoice(line)

creates an invoice(line) for a delivery

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$dealerId = 56; // int | ID of the dealer
$lotId = 56; // int | Id of the lot sold
$unitPrice = 56; // int | price of the unit aka fee
$quantity = 56; // int | quantity
$licensePlate = 'licensePlate_example'; // string | licensePlate
$constructionYear = 'constructionYear_example'; // string | constructionYear
$make = 'make_example'; // string | make
$model = 'model_example'; // string | model

try {
    $apiInstance->createInvoice($country, $vehicleType, $dealerId, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->createInvoice: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **dealerId** | **int**| ID of the dealer | [optional]
 **lotId** | **int**| Id of the lot sold | [optional]
 **unitPrice** | **int**| price of the unit aka fee | [optional]
 **quantity** | **int**| quantity | [optional]
 **licensePlate** | **string**| licensePlate | [optional]
 **constructionYear** | **string**| constructionYear | [optional]
 **make** | **string**| make | [optional]
 **model** | **string**| model | [optional]

### Return type

void (empty response body)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: `multipart/form-data`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInvoiceListByDealer()`

```php
getInvoiceListByDealer($country, $vehicleType, $dealerId): \Dealerdirect\FinanceApiClient\Model\Invoice[]
```

get invoices of dealer

Returns a list of invoiced of a Dealer

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$dealerId = 'dealerId_example'; // string

try {
    $result = $apiInstance->getInvoiceListByDealer($country, $vehicleType, $dealerId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->getInvoiceListByDealer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **dealerId** | **string**|  |

### Return type

[**\Dealerdirect\FinanceApiClient\Model\Invoice[]**](../Model/Invoice.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInvoicePDFByID()`

```php
getInvoicePDFByID($country, $vehicleType, $dealerId, $invoiceNumber): \SplFileObject
```

Get a invoice in PDF

Returns a PDF for an invoice

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure OAuth2 access token for authorization: passport
$config = Dealerdirect\FinanceApiClient\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');


$apiInstance = new Dealerdirect\FinanceApiClient\Api\InvoicesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$country = nl; // string
$vehicleType = car; // string
$dealerId = 'dealerId_example'; // string
$invoiceNumber = 'invoiceNumber_example'; // string

try {
    $result = $apiInstance->getInvoicePDFByID($country, $vehicleType, $dealerId, $invoiceNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InvoicesApi->getInvoicePDFByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **country** | **string**|  |
 **vehicleType** | **string**|  |
 **dealerId** | **string**|  |
 **invoiceNumber** | **string**|  |

### Return type

[**\SplFileObject**](../Model/\SplFileObject.md)

### Authorization

[passport](../../README.md#passport)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/pdf`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
