<?php

/**
 * InvoicesApiTest
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.2.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Please update the test case below to test the endpoint.
 */

namespace Dealerdirect\FinanceApiClient\Test\Api;

use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\Api\InvoicesApi;

use Dealerdirect\FinanceApiClient\Model\InvoiceLine;

use Dealerdirect\FinanceApiClient\Model\Invoice;

use Dealerdirect\FinanceApiClient\Client as FinanceApiClient;
use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\ObjectSerializer;
use PHPUnit\Framework\TestCase;

/**
 * InvoicesApiTest Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InvoicesApiTest extends TestCase
{
    private static ?InvoicesApi $api = null;
            // hardcoded default are bad i know
    private string $invoiceID = '7383f1e9-6074-4083-b091-11506fd3a456';

    /**
     * Setup before running any test cases
     */
    public static function setUpBeforeClass(): void
    {
        $baseUrl = getenv('FINANCE_API_URL');
        $clientId = (int) getenv('FINANCE_API_CLIENT_ID');
        $clientSecret = getenv('FINANCE_API_CLIENT_SECRET');
        if ($baseUrl && $clientId && $clientSecret) {
            self::$api = (new FinanceApiClient(
                $baseUrl,
                $clientId,
                $clientSecret,
                [
                    'write:invoices',
                    'read:invoices'
                ]
            ))->getInvoicesApi();
        }
    }

    /**
     * Setup before running each test case
     */
    public function setUp(): void
    {
        if (is_null(self::$api)) {
            $this->markTestSkipped(
                'Api endpoint not available'
            );
        }
    }

    /**
     * Clean up after running each test case
     */
    public function tearDown(): void
    {
    }

    /**
     * Clean up after running all test cases
     */
    public static function tearDownAfterClass(): void
    {
    }

    /**
     * Test case for createInvoice
     *
     * create an invoice(line).
     *
     */
    public function testCreateInvoice()
    {
        $this->assertNotNull(self::$api);
        list($result,$code,$headers) = self::$api->createInvoiceWithHttpInfo(
            'nl',
            'car',
            123456,
            321,
            1,
            '63-pv-sv',
            '2000',
            'Citroën',
            "C3",
            null,
            null,
            9999
        );
        $this->assertEquals(200, $code, "Api result code should be 200");
        $this->assertIsString($result->getProviderId());
        $this->assertIsString($result->getProviderType());
        $this->assertEquals('open', $result->getStatus());
        $this->assertIsBool($result->getResult());
        $this->assertTrue($result->getResult());
    }

    /**
     * Test case for getInvoiceDetails
     *
     * get invoice with line details.
     *
     */
    public function testGetInvoiceDetails()
    {
        $this->assertNotNull(self::$api);
        list($response, $code, $headers) = self::$api->getInvoiceDetailsWithHttpInfo(
            'nl',
            'car',
            $this->invoiceID,
            9999
        );
        $this->assertEquals(200, $code, "Api result code should be 200");
        $this->assertIsArray($response, "List response should always be an array");
        $this->assertCount(1, $response, "Result should be 1 invoice in list");
        $this->assertContainsOnlyInstancesOf(
            Invoice::class,
            $response,
            "Array should only contain Invoices"
        );

        $invoice = reset($response);

        $this->assertEquals($this->invoiceID, $invoice->getInvoiceId());
        $this->assertContainsOnlyInstancesOf(
            InvoiceLine::class,
            $invoice->getLines(),
            "Array should only contain InvoiceLines"
        );
        $this->assertGreaterThanOrEqual(
            1,
            count($invoice->getLines()),
            "Invoice should have 1 line or more"
        );
    }

    /**
     * Test case for getInvoiceList
     *
     * get invoices of dealer.
     *
     */
    public function testGetInvoiceList()
    {
        $this->assertNotNull(self::$api);
        list($response, $code, $headers) = self::$api->getInvoiceListWithHttpInfo(
            'nl',
            'car',
            '2020',
            null,
            null,
            9999,
            null
        );
        $this->assertEquals(200, $code, "Api result code should be 200");
        $this->assertIsArray($response, "List response should always be an array");
        $this->assertContainsOnlyInstancesOf(
            Invoice::class,
            $response,
            "Array should only contain Invoices"
        );
        foreach ($response as $value) {
            $this->assertEquals(9999, $value['dealerId'], "Returned an invoice not of requested dealer ID");
        }
    }

    /**
     * Test case for getInvoicePDFByID
     *
     * Get an invoice in PDF.
     *
     */
    public function testGetInvoicePDFByID()
    {
        $this->assertNotNull(self::$api);
        list($response, $code, $headers) = self::$api->getInvoicePDFByIDWithHttpInfo(
            'nl',
            'car',
            $this->invoiceID,
            9999
        );
        $this->assertEquals(200, $code, "Api result code should be 200");
        $this->assertInstanceOf(\SplFileObject::class, $response, "Response should be a file");
        $this->assertEquals("application/pdf", reset($headers['Content-Type']), "Pdf response should be a PDF");
    }
}
