<?php

/**
 * InvoicesApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Finance-API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0.0
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.2.0-SNAPSHOT
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Dealerdirect\FinanceApiClient\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Dealerdirect\FinanceApiClient\ApiException;
use Dealerdirect\FinanceApiClient\Configuration;
use Dealerdirect\FinanceApiClient\HeaderSelector;
use Dealerdirect\FinanceApiClient\ObjectSerializer;

/**
 * InvoicesApi Class Doc Comment
 *
 * @category Class
 * @package  Dealerdirect\FinanceApiClient
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InvoicesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createInvoice
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\InlineResponse200|\Dealerdirect\FinanceApiClient\Model\InlineResponse400
     */
    public function createInvoice($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null)
    {
        list($response) = $this->createInvoiceWithHttpInfo($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId);
        return $response;
    }

    /**
     * Operation createInvoiceWithHttpInfo
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\InlineResponse200|\Dealerdirect\FinanceApiClient\Model\InlineResponse400, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInvoiceWithHttpInfo($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null)
    {
        $request = $this->createInvoiceRequest($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\InlineResponse200' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\InlineResponse200', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\Dealerdirect\FinanceApiClient\Model\InlineResponse400' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\InlineResponse400', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\InlineResponse200';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\InlineResponse200',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\InlineResponse400',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInvoiceAsync
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsync($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null)
    {
        return $this->createInvoiceAsyncWithHttpInfo($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInvoiceAsyncWithHttpInfo
     *
     * create an invoice(line)
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInvoiceAsyncWithHttpInfo($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null)
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\InlineResponse200';
        $request = $this->createInvoiceRequest($country, $vehicleType, $lotId, $unitPrice, $quantity, $licensePlate, $constructionYear, $make, $model, $makeAndModel, $description, $dealerId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInvoice'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $lotId Id of the lot sold (optional)
     * @param  int $unitPrice Price of the unit aka fee (optional)
     * @param  int $quantity Quantity (optional)
     * @param  string $licensePlate License plate (optional)
     * @param  string $constructionYear Construction year (optional)
     * @param  string $make Make (optional)
     * @param  string $model model (optional)
     * @param  string $makeAndModel Make and model (optional)
     * @param  string $description General description for invoice line (optional)
     * @param  int $dealerId Id of the dealer buying the lot (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInvoiceRequest($country, $vehicleType, $lotId = null, $unitPrice = null, $quantity = null, $licensePlate = null, $constructionYear = null, $make = null, $model = null, $makeAndModel = null, $description = null, $dealerId = null)
    {
        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling createInvoice'
            );
        }
        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling createInvoice'
            );
        }
        if ($constructionYear !== null && !preg_match("/^\\d{4}$/", $constructionYear)) {
            throw new \InvalidArgumentException("invalid value for \"constructionYear\" when calling InvoicesApi.createInvoice, must conform to the pattern /^\\d{4}$/.");
        }


        $resourcePath = '/api/{country}/{vehicleType}/invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }

        // form params
        if ($lotId !== null) {
            $formParams['lot_id'] = ObjectSerializer::toFormValue($lotId);
        }
        // form params
        if ($unitPrice !== null) {
            $formParams['unit_price'] = ObjectSerializer::toFormValue($unitPrice);
        }
        // form params
        if ($quantity !== null) {
            $formParams['quantity'] = ObjectSerializer::toFormValue($quantity);
        }
        // form params
        if ($licensePlate !== null) {
            $formParams['license_plate'] = ObjectSerializer::toFormValue($licensePlate);
        }
        // form params
        if ($constructionYear !== null) {
            $formParams['construction_year'] = ObjectSerializer::toFormValue($constructionYear);
        }
        // form params
        if ($make !== null) {
            $formParams['make'] = ObjectSerializer::toFormValue($make);
        }
        // form params
        if ($model !== null) {
            $formParams['model'] = ObjectSerializer::toFormValue($model);
        }
        // form params
        if ($makeAndModel !== null) {
            $formParams['make_and_model'] = ObjectSerializer::toFormValue($makeAndModel);
        }
        // form params
        if ($description !== null) {
            $formParams['description'] = ObjectSerializer::toFormValue($description);
        }
        // form params
        if ($dealerId !== null) {
            $formParams['dealer_id'] = ObjectSerializer::toFormValue($dealerId);
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['multipart/form-data']
            );
            if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
                $multipart = true;
                $headers = $this->headerSelector->selectHeadersForMultipart(
                    ['application/json']
                );
            }
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoiceDetails
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  string $invoiceProviderId invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\Invoice[]
     */
    public function getInvoiceDetails($country, $vehicleType, $invoiceProviderId, $dealerId)
    {
        list($response) = $this->getInvoiceDetailsWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId);
        return $response;
    }

    /**
     * Operation getInvoiceDetailsWithHttpInfo
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\Invoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceDetailsWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId)
    {
        $request = $this->getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\Invoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\Invoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoiceDetailsAsync
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceDetailsAsync($country, $vehicleType, $invoiceProviderId, $dealerId)
    {
        return $this->getInvoiceDetailsAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoiceDetailsAsyncWithHttpInfo
     *
     * get invoice with line details
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceDetailsAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId)
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
        $request = $this->getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoiceDetails'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId Filter invoices on provided dealer id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoiceDetailsRequest($country, $vehicleType, $invoiceProviderId, $dealerId)
    {
        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoiceDetails'
            );
        }
        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoiceDetails'
            );
        }
        // verify the required parameter 'invoiceProviderId' is set
        if ($invoiceProviderId === null || (is_array($invoiceProviderId) && count($invoiceProviderId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoiceProviderId when calling getInvoiceDetails'
            );
        }
        // verify the required parameter 'dealerId' is set
        if ($dealerId === null || (is_array($dealerId) && count($dealerId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dealerId when calling getInvoiceDetails'
            );
        }

        $resourcePath = '/api/{country}/{vehicleType}/invoices/{invoiceProviderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($dealerId !== null) {
            if ('form' === 'form' && is_array($dealerId)) {
                foreach ($dealerId as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['dealer_id'] = $dealerId;
            }
        }


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }
        // path params
        if ($invoiceProviderId !== null) {
            $resourcePath = str_replace(
                '{' . 'invoiceProviderId' . '}',
                ObjectSerializer::toPathValue($invoiceProviderId),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
            if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
                $multipart = true;
                $headers = $this->headerSelector->selectHeadersForMultipart(
                    ['application/json']
                );
            }
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoiceList
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Dealerdirect\FinanceApiClient\Model\Invoice[]
     */
    public function getInvoiceList($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null)
    {
        list($response) = $this->getInvoiceListWithHttpInfo($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus);
        return $response;
    }

    /**
     * Operation getInvoiceListWithHttpInfo
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Dealerdirect\FinanceApiClient\Model\Invoice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceListWithHttpInfo($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null)
    {
        $request = $this->getInvoiceListRequest($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\Dealerdirect\FinanceApiClient\Model\Invoice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Dealerdirect\FinanceApiClient\Model\Invoice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Dealerdirect\FinanceApiClient\Model\Invoice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoiceListAsync
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceListAsync($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null)
    {
        return $this->getInvoiceListAsyncWithHttpInfo($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoiceListAsyncWithHttpInfo
     *
     * get invoices of dealer
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoiceListAsyncWithHttpInfo($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null)
    {
        $returnType = '\Dealerdirect\FinanceApiClient\Model\Invoice[]';
        $request = $this->getInvoiceListRequest($country, $vehicleType, $year, $paidStatus, $invoiceType, $dealerId, $invoiceStatus);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoiceList'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  int $year Filter invoices on provided year (optional)
     * @param  string[] $paidStatus Filter invoices on provided paid status (optional)
     * @param  string[] $invoiceType Filter invoices on provided paid invoice type (optional)
     * @param  int $dealerId Filter invoices on provided dealer id (optional)
     * @param  string $invoiceStatus Filter invoices on provided invoice status (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoiceListRequest($country, $vehicleType, $year = null, $paidStatus = null, $invoiceType = null, $dealerId = null, $invoiceStatus = null)
    {
        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoiceList'
            );
        }
        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoiceList'
            );
        }

        $resourcePath = '/api/{country}/{vehicleType}/invoices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($year !== null) {
            if ('form' === 'form' && is_array($year)) {
                foreach ($year as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['year'] = $year;
            }
        }
        // query params
        if (is_array($paidStatus)) {
            $paidStatus = ObjectSerializer::serializeCollection($paidStatus, 'form', true);
        }
        if ($paidStatus !== null) {
            $queryParams['paid_status'] = $paidStatus;
        }
        // query params
        if (is_array($invoiceType)) {
            $invoiceType = ObjectSerializer::serializeCollection($invoiceType, 'form', true);
        }
        if ($invoiceType !== null) {
            $queryParams['invoice_type'] = $invoiceType;
        }
        // query params
        if ($dealerId !== null) {
            if ('form' === 'form' && is_array($dealerId)) {
                foreach ($dealerId as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['dealer_id'] = $dealerId;
            }
        }
        // query params
        if ($invoiceStatus !== null) {
            if ('form' === 'form' && is_array($invoiceStatus)) {
                foreach ($invoiceStatus as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['invoice_status'] = $invoiceStatus;
            }
        }


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
            if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
                $multipart = true;
                $headers = $this->headerSelector->selectHeadersForMultipart(
                    ['application/json']
                );
            }
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInvoicePDFByID
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country country (required)
     * @param  string $vehicleType vehicleType (required)
     * @param  string $invoiceProviderId invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SplFileObject
     */
    public function getInvoicePDFByID($country, $vehicleType, $invoiceProviderId, $dealerId = null)
    {
        list($response) = $this->getInvoicePDFByIDWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId);
        return $response;
    }

    /**
     * Operation getInvoicePDFByIDWithHttpInfo
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     *
     * @throws \Dealerdirect\FinanceApiClient\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoicePDFByIDWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId = null)
    {
        $request = $this->getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch ($statusCode) {
                case 200:
                    if ('\SplFileObject' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SplFileObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SplFileObject';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SplFileObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInvoicePDFByIDAsync
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoicePDFByIDAsync($country, $vehicleType, $invoiceProviderId, $dealerId = null)
    {
        return $this->getInvoicePDFByIDAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInvoicePDFByIDAsyncWithHttpInfo
     *
     * Get an invoice in PDF
     *
     * Client to communicate with the Dealerdirect Finance-API
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInvoicePDFByIDAsyncWithHttpInfo($country, $vehicleType, $invoiceProviderId, $dealerId = null)
    {
        $returnType = '\SplFileObject';
        $request = $this->getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInvoicePDFByID'
     *
     * @param  string $country (required)
     * @param  string $vehicleType (required)
     * @param  string $invoiceProviderId (required)
     * @param  int $dealerId ID of the dealer the invoice was meant for (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInvoicePDFByIDRequest($country, $vehicleType, $invoiceProviderId, $dealerId = null)
    {
        // verify the required parameter 'country' is set
        if ($country === null || (is_array($country) && count($country) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $country when calling getInvoicePDFByID'
            );
        }
        // verify the required parameter 'vehicleType' is set
        if ($vehicleType === null || (is_array($vehicleType) && count($vehicleType) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $vehicleType when calling getInvoicePDFByID'
            );
        }
        // verify the required parameter 'invoiceProviderId' is set
        if ($invoiceProviderId === null || (is_array($invoiceProviderId) && count($invoiceProviderId) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invoiceProviderId when calling getInvoicePDFByID'
            );
        }

        $resourcePath = '/api/{country}/{vehicleType}/invoices/{invoiceProviderId}/pdf';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($dealerId !== null) {
            if ('form' === 'form' && is_array($dealerId)) {
                foreach ($dealerId as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['dealer_id'] = $dealerId;
            }
        }


        // path params
        if ($country !== null) {
            $resourcePath = str_replace(
                '{' . 'country' . '}',
                ObjectSerializer::toPathValue($country),
                $resourcePath
            );
        }
        // path params
        if ($vehicleType !== null) {
            $resourcePath = str_replace(
                '{' . 'vehicleType' . '}',
                ObjectSerializer::toPathValue($vehicleType),
                $resourcePath
            );
        }
        // path params
        if ($invoiceProviderId !== null) {
            $resourcePath = str_replace(
                '{' . 'invoiceProviderId' . '}',
                ObjectSerializer::toPathValue($invoiceProviderId),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/pdf']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/pdf'],
                []
            );
            if (($headers['Content-Type'] ?? null) === 'multipart/form-data') {
                $multipart = true;
                $headers = $this->headerSelector->selectHeadersForMultipart(
                    ['application/pdf']
                );
            }
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
