<?php

declare(strict_types=1);

namespace Dealerdirect\Generic\Tests\Enums;

use Dealerdirect\Generic\Enums\Interfaces\CallGroup;
use Dealerdirect\Generic\Enums\PhoneNumber;
use PHPUnit\Framework\TestCase;

/**
 * @covers \Dealerdirect\Generic\Enums\PhoneNumber
 *
 * @uses \Dealerdirect\Generic\Enums\Interfaces\CallGroup
 * @uses \Dealerdirect\Generic\Enums\Car\CallGroup
 * @uses \Dealerdirect\Generic\Enums\Motorbike\CallGroup
 * @uses \Dealerdirect\Generic\Enums\SiteReference
 */
final class PhoneNumberTest extends TestCase
{
    /**
     * @dataProvider provide_phone_numbers
     */
    public function test_to_call_groups(PhoneNumber $phoneNumber): void
    {
        $callGroups = $phoneNumber->toCallGroups();

        $this->assertIsArray($callGroups);
        $this->assertNotEmpty($callGroups);
        $this->assertContainsOnlyInstancesOf(CallGroup::class, $callGroups);
    }

    public static function provide_phone_numbers(): iterable
    {
        foreach (PhoneNumber::cases() as $phoneNumber) {
            yield $phoneNumber->name => [$phoneNumber];
        }
    }
}
