# DealerDirect Generic PHP

## Introduction

Generic PHP classes and functionality that can be used across all of the PHP
projects within DealerDirect.

### Installation

The preferred means of installing this code is by adding it as a Composer
dependency to a project. This is done by adding this repository to a project's
`composer.json` file:

```json
    {
      "repositories": [{
        "type": "composer",
        "url": "https://satis.dealerdirect.io/"
      }],
    }
```

And then adding this project as a composer dependency:

`composer require 'dealerdirect/generic-category'`

## Usage

This package offers two sorts of behaviour:

1. Enum constants

### A word on hard-coded values, magic numbers and database id's

The code of various Dealerdirect applications contains a lot of hard-coded values,
magic numbers and direct references to id's in databases.

Eventually, when all hard-coded values and magic numbers have been successfully
herded together, they can/should be moved to a database and removed from the
code-base. All such information would then only live in instances of **Entity
classes**.

To clean up the code in all of the applications, an interim solution is needed.
This solution needs to make a clear separation between which data is available
and objects in which such data is stored.

To have Objects in which concrete values can be stored **Immutable classes** have
been created. In order to validate the data that goes into such objects, **Category
classes** have been created that contain the available values which **Immutable
objects** may contain

When all of the hard-coded values, magic numbers and id references have been
moved to a database, the **Category classes** can be deprecated and, instead of
using **Immutable classes** to hold scalar values, the Repositories should
contain/return **Entity objects** that have been populated from the database.
