<?php

declare(strict_types=1);

namespace Dealerdirect\Generic\Tests\Enums\Motorbike;

use Dealerdirect\Generic\Enums\Motorbike\CallGroup;
use DealerDirect\Generic\Enums\PhoneNumber;
use Dealerdirect\Generic\Enums\PhoneNumberType;
use Dealerdirect\Generic\Enums\SiteReference;
use PHPUnit\Framework\TestCase;

/**
 * @covers \Dealerdirect\Generic\Enums\Motorbike\CallGroup
 *
 * @uses \Dealerdirect\Generic\Enums\PhoneNumber
 * @uses \Dealerdirect\Generic\Enums\SiteReference
 */
final class CallGroupTest extends TestCase
{
    /**
     * @dataProvider provide_call_groups
     */
    public function test_to_phone_number_for_consumer(CallGroup $callGroup): void
    {
        $phoneNumber = $callGroup->toPhoneNumber(PhoneNumberType::CONSUMER);
        $this->assertInstanceOf(PhoneNumber::class, $phoneNumber);
        $this->assertContains($callGroup, $phoneNumber->toCallGroups());

        $phoneNumber = $callGroup->toConsumerPhoneNumber();
        $this->assertInstanceOf(PhoneNumber::class, $phoneNumber);
        $this->assertContains($callGroup, $phoneNumber->toCallGroups());
    }

    /**
     * @dataProvider provide_call_groups
     */
    public function test_to_phone_number_for_dealer(CallGroup $callGroup): void
    {
        $phoneNumber = $callGroup->toPhoneNumber(PhoneNumberType::DEALER);
        $this->assertInstanceOf(PhoneNumber::class, $phoneNumber);
        $this->assertContains($callGroup, $phoneNumber->toCallGroups());

        $phoneNumber = $callGroup->toDealerPhoneNumber();
        $this->assertInstanceOf(PhoneNumber::class, $phoneNumber);
        $this->assertContains($callGroup, $phoneNumber->toCallGroups());
    }

    /**
     * @dataProvider provide_call_groups
     */
    public function test_to_site_reference(CallGroup $callGroup): void
    {
        $siteReference = $callGroup->toSiteReference();

        $this->assertInstanceOf(SiteReference::class, $siteReference);
        $this->assertTrue($siteReference->isActive(), 'The site reference should be active');
        $this->assertContains($callGroup, $siteReference->toCallGroups());
    }

    public static function provide_call_groups(): iterable
    {
        foreach (CallGroup::cases() as $case) {
            yield $case->name => [$case];
        }
    }
}
