<?php

declare(strict_types=1);

namespace Dealerdirect\Generic\Enums;

enum CallStatus: int
{
    /**
     * in behandeling
     */
    case BEING_PROCESSED = 5;

    /**
     * opnieuw bellen
     */
    case CALL_AGAIN = 7;

    /**
     * na veiling terugbellen
     */
    case CALL_BACK_AFTER_AUCTION = 6;

    /**
     * direct bellen
     */
    case CALL_DIRECT = 1;

    /**
     * gebeld
     */
    case CALLED = 2;

    /**
     * voicemail ingesproken
     */
    case LEFT_VOICE_MAIL_MESSAGE = 12;

    /**
     * kavel doorgenomen
     */
    case LOT_DISCUSSED_WITH_CONSUMER = 14;

    /**
     * geen gehoor
     */
    case NO_ANSWER = 3;

    /**
     * uitgeschreven
     */
    case LEAVING_SERVICE = 4;

    /**
     * opnieuw geactiveerd
     */
    case REACTIVATED = 8;

    /**
     * verzoek contact gegevens
     */
    case REQUEST_CONTACT_INFORMATION = 11;

    /**
     * verzoek contact consument
     */
    case REQUEST_CONTACT_CONSUMER = 61;

    /**
     * RTC
     */
    case RESPECT_THE_CHANNEL = 15;

    /**
     * zelf verkocht
     */
    case SOLD_BY_CONSUMER = 13;

    /**
     * verkocht op andere kavel
     */
    case SOLD_UNDER_OTHER_LOT = 10;

    /**
     * turboveiling
     */
    case TURBO_AUCTION = 9;

    /**
     * Fake
     */
    case FAKE = 21;

    /**
     * Dubbel
     */
    case DUPLICATE = 31;

    /**
     * TBA
     */
    case CALL_BACK_APPOINTMENT = 41;

    /**
     * Doorverbonden
     */
    case PUT_THROUGH = 51;

    /**
     * Label Duplicate
     */
    case LABEL_DUPLICATE = 71;

    /**
     * WhatsApp Flow
     */
    case WHATSAPP_FLOW = 81;
}
