<?php

namespace DealerDirect\Generic\Category;

/**
 * Class VehicleTypeCarCondition
 *
 * Car condition values
 *
 * Note that the values are *not* consistent with the values in VehicleTypeMotorCondition
 *
 * @package DealerDirect\Generic\Category
 */
class VehicleTypeCarCondition extends AbstractEnum
{
    // Condition not specified/unknown
    public const UNKNOWN = 0;
    public const NOT_SPECIFIED = 0;
    /**
     * Vehicle condition, "as good as *NEW*"
     */
    public const AS_NEW = 4;
    public const AS_NEW_CONDITION = 4;
    /**
     * Vehicle in *good* condition ("goed")
     */
    public const GOOD = 1;
    public const GOOD_CONDITION = 1;
    /**
     * Vehicle in *average* condition ("redelijk")
     */
    public const AVERAGE = 2;
    public const AVERAGE_CONDITION = 2;
    /**
     * Vehicle in *bad* condition ("slecht")
     */
    public const BAD = 3;
    public const BAD_CONDITION = 3;
}
