<?php

declare(strict_types=1);

namespace Dealerdirect\Generic\Enums\Interfaces;

use Dealerdirect\Generic\Enums\PhoneNumber;
use Dealerdirect\Generic\Enums\PhoneNumberType;
use Dealerdirect\Generic\Enums\SiteReference;

interface CallGroup extends \BackedEnum
{
    /**
     * Get the related PhoneNumber enum for this CallGroup.
     *
     * @param  PhoneNumberType $type The type of phone number to get. e.g. consumer, dealer, etc.
     * @return PhoneNumber
     */
    public function toPhoneNumber(PhoneNumberType $type): PhoneNumber;

    /**
     * Get the related SiteReference enum for this CallGroup.
     *
     * @return SiteReference
     */
    public function toSiteReference(): SiteReference;

    /**
     * Get the label for this CallGroup.
     *
     * @return string
     */
    public function toLabel(): string;
}
