<?php

namespace DealerDirect\Generic\Category;

/**
 * RFC-5646 compliant "Tag for Identifying Languages"
 *
 * The locale format is:
 *
 *      language[_territory][.codeset][@modifier]
 *
 * @see http://demo.icu-project.org/icu-bin/locexp#region
 */
final class Locale extends AbstractEnum
{
    const AF = 'af'; // Afrikaans
    const AF_NA = 'af_NA'; // Afrikaans (Namibia)
    const AF_ZA = 'af_ZA'; // Afrikaans (South Africa)
    const AK = 'ak'; // Akan
    const AK_GH = 'ak_GH'; // Akan (Ghana)
    const SQ = 'sq'; // Albanian
    const SQ_AL = 'sq_AL'; // Albanian (Albania)
    const SQ_XK = 'sq_XK'; // Albanian (Kosovo)
    const SQ_MK = 'sq_MK'; // Albanian (Macedonia)
    const AM = 'am'; // Amharic
    const AM_ET = 'am_ET'; // Amharic (Ethiopia)
    const AR = 'ar'; // Arabic
    const AR_DZ = 'ar_DZ'; // Arabic (Algeria)
    const AR_BH = 'ar_BH'; // Arabic (Bahrain)
    const AR_TD = 'ar_TD'; // Arabic (Chad)
    const AR_KM = 'ar_KM'; // Arabic (Comoros)
    const AR_DJ = 'ar_DJ'; // Arabic (Djibouti)
    const AR_EG = 'ar_EG'; // Arabic (Egypt)
    const AR_ER = 'ar_ER'; // Arabic (Eritrea)
    const AR_IQ = 'ar_IQ'; // Arabic (Iraq)
    const AR_IL = 'ar_IL'; // Arabic (Israel)
    const AR_JO = 'ar_JO'; // Arabic (Jordan)
    const AR_KW = 'ar_KW'; // Arabic (Kuwait)
    const AR_LB = 'ar_LB'; // Arabic (Lebanon)
    const AR_LY = 'ar_LY'; // Arabic (Libya)
    const AR_MR = 'ar_MR'; // Arabic (Mauritania)
    const AR_MA = 'ar_MA'; // Arabic (Morocco)
    const AR_OM = 'ar_OM'; // Arabic (Oman)
    const AR_PS = 'ar_PS'; // Arabic (Palestinian Territories)
    const AR_QA = 'ar_QA'; // Arabic (Qatar)
    const AR_SA = 'ar_SA'; // Arabic (Saudi Arabia)
    const AR_SO = 'ar_SO'; // Arabic (Somalia)
    const AR_SS = 'ar_SS'; // Arabic (South Sudan)
    const AR_SD = 'ar_SD'; // Arabic (Sudan)
    const AR_SY = 'ar_SY'; // Arabic (Syria)
    const AR_TN = 'ar_TN'; // Arabic (Tunisia)
    const AR_AE = 'ar_AE'; // Arabic (United Arab Emirates)
    const AR_EH = 'ar_EH'; // Arabic (Western Sahara)
    const AR_YE = 'ar_YE'; // Arabic (Yemen)
    const HY = 'hy'; // Armenian
    const HY_AM = 'hy_AM'; // Armenian (Armenia)
    const AS_ = 'as'; // Assamese
    const AS_IN = 'as_IN'; // Assamese (India)
    const AZ = 'az'; // Azerbaijani
    const AZ_AZ = 'az_AZ'; // Azerbaijani (Azerbaijan)
    const AZ_CYRL_AZ = 'az_Cyrl_AZ'; // Azerbaijani (Cyrillic, Azerbaijan)
    const AZ_CYRL = 'az_Cyrl'; // Azerbaijani (Cyrillic)
    const AZ_LATN_AZ = 'az_Latn_AZ'; // Azerbaijani (Latin, Azerbaijan)
    const AZ_LATN = 'az_Latn'; // Azerbaijani (Latin)
    const BM = 'bm'; // Bambara
    const BM_LATN_ML = 'bm_Latn_ML'; // Bambara (Latin, Mali)
    const BM_LATN = 'bm_Latn'; // Bambara (Latin)
    const EU = 'eu'; // Basque
    const EU_ES = 'eu_ES'; // Basque (Spain)
    const BE = 'be'; // Belarusian
    const BE_BY = 'be_BY'; // Belarusian (Belarus)
    const BN = 'bn'; // Bengali
    const BN_BD = 'bn_BD'; // Bengali (Bangladesh)
    const BN_IN = 'bn_IN'; // Bengali (India)
    const BS = 'bs'; // Bosnian
    const BS_BA = 'bs_BA'; // Bosnian (Bosnia & Herzegovina)
    const BS_CYRL_BA = 'bs_Cyrl_BA'; // Bosnian (Cyrillic, Bosnia & Herzegovina)
    const BS_CYRL = 'bs_Cyrl'; // Bosnian (Cyrillic)
    const BS_LATN_BA = 'bs_Latn_BA'; // Bosnian (Latin, Bosnia & Herzegovina)
    const BS_LATN = 'bs_Latn'; // Bosnian (Latin)
    const BR = 'br'; // Breton
    const BR_FR = 'br_FR'; // Breton (France)
    const BG = 'bg'; // Bulgarian
    const BG_BG = 'bg_BG'; // Bulgarian (Bulgaria)
    const MY = 'my'; // Burmese
    const MY_MM = 'my_MM'; // Burmese (Myanmar (Burma))
    const CA = 'ca'; // Catalan
    const CA_AD = 'ca_AD'; // Catalan (Andorra)
    const CA_FR = 'ca_FR'; // Catalan (France)
    const CA_IT = 'ca_IT'; // Catalan (Italy)
    const CA_ES = 'ca_ES'; // Catalan (Spain)
    const ZH = 'zh'; // Chinese
    const ZH_CN = 'zh_CN'; // Chinese (China)
    const ZH_HK = 'zh_HK'; // Chinese (Hong Kong SAR China)
    const ZH_MO = 'zh_MO'; // Chinese (Macau SAR China)
    const ZH_HANS_CN = 'zh_Hans_CN'; // Chinese (Simplified, China)
    const ZH_HANS_HK = 'zh_Hans_HK'; // Chinese (Simplified, Hong Kong SAR China)
    const ZH_HANS_MO = 'zh_Hans_MO'; // Chinese (Simplified, Macau SAR China)
    const ZH_HANS_SG = 'zh_Hans_SG'; // Chinese (Simplified, Singapore)
    const ZH_HANS = 'zh_Hans'; // Chinese (Simplified)
    const ZH_SG = 'zh_SG'; // Chinese (Singapore)
    const ZH_TW = 'zh_TW'; // Chinese (Taiwan)
    const ZH_HANT_HK = 'zh_Hant_HK'; // Chinese (Traditional, Hong Kong SAR China)
    const ZH_HANT_MO = 'zh_Hant_MO'; // Chinese (Traditional, Macau SAR China)
    const ZH_HANT_TW = 'zh_Hant_TW'; // Chinese (Traditional, Taiwan)
    const ZH_HANT = 'zh_Hant'; // Chinese (Traditional)
    const KW = 'kw'; // Cornish
    const KW_GB = 'kw_GB'; // Cornish (United Kingdom)
    const HR = 'hr'; // Croatian
    const HR_BA = 'hr_BA'; // Croatian (Bosnia & Herzegovina)
    const HR_HR = 'hr_HR'; // Croatian (Croatia)
    const CS = 'cs'; // Czech
    const CS_CZ = 'cs_CZ'; // Czech (Czech Republic)
    const DA = 'da'; // Danish
    const DA_DK = 'da_DK'; // Danish (Denmark)
    const DA_GL = 'da_GL'; // Danish (Greenland)
    const NL = 'nl'; // Dutch
    const NL_AW = 'nl_AW'; // Dutch (Aruba)
    const NL_BE = 'nl_BE'; // Dutch (Belgium)
    const NL_BQ = 'nl_BQ'; // Dutch (Caribbean Netherlands)
    const NL_CW = 'nl_CW'; // Dutch (Curaçao)
    const NL_NL = 'nl_NL'; // Dutch (Netherlands)
    const NL_SX = 'nl_SX'; // Dutch (Sint Maarten)
    const NL_SR = 'nl_SR'; // Dutch (Suriname)
    const DZ = 'dz'; // Dzongkha
    const DZ_BT = 'dz_BT'; // Dzongkha (Bhutan)
    const EN = 'en'; // English
    const EN_AS = 'en_AS'; // English (American Samoa)
    const EN_AI = 'en_AI'; // English (Anguilla)
    const EN_AG = 'en_AG'; // English (Antigua & Barbuda)
    const EN_AU = 'en_AU'; // English (Australia)
    const EN_BS = 'en_BS'; // English (Bahamas)
    const EN_BB = 'en_BB'; // English (Barbados)
    const EN_BE = 'en_BE'; // English (Belgium)
    const EN_BZ = 'en_BZ'; // English (Belize)
    const EN_BM = 'en_BM'; // English (Bermuda)
    const EN_BW = 'en_BW'; // English (Botswana)
    const EN_IO = 'en_IO'; // English (British Indian Ocean Territory)
    const EN_VG = 'en_VG'; // English (British Virgin Islands)
    const EN_CM = 'en_CM'; // English (Cameroon)
    const EN_CA = 'en_CA'; // English (Canada)
    const EN_KY = 'en_KY'; // English (Cayman Islands)
    const EN_CX = 'en_CX'; // English (Christmas Island)
    const EN_CC = 'en_CC'; // English (Cocos (Keeling) Islands)
    const EN_CK = 'en_CK'; // English (Cook Islands)
    const EN_DG = 'en_DG'; // English (Diego Garcia)
    const EN_DM = 'en_DM'; // English (Dominica)
    const EN_ER = 'en_ER'; // English (Eritrea)
    const EN_FK = 'en_FK'; // English (Falkland Islands)
    const EN_FJ = 'en_FJ'; // English (Fiji)
    const EN_GM = 'en_GM'; // English (Gambia)
    const EN_GH = 'en_GH'; // English (Ghana)
    const EN_GI = 'en_GI'; // English (Gibraltar)
    const EN_GD = 'en_GD'; // English (Grenada)
    const EN_GU = 'en_GU'; // English (Guam)
    const EN_GG = 'en_GG'; // English (Guernsey)
    const EN_GY = 'en_GY'; // English (Guyana)
    const EN_HK = 'en_HK'; // English (Hong Kong SAR China)
    const EN_IN = 'en_IN'; // English (India)
    const EN_IE = 'en_IE'; // English (Ireland)
    const EN_IM = 'en_IM'; // English (Isle of Man)
    const EN_JM = 'en_JM'; // English (Jamaica)
    const EN_JE = 'en_JE'; // English (Jersey)
    const EN_KE = 'en_KE'; // English (Kenya)
    const EN_KI = 'en_KI'; // English (Kiribati)
    const EN_LS = 'en_LS'; // English (Lesotho)
    const EN_LR = 'en_LR'; // English (Liberia)
    const EN_MO = 'en_MO'; // English (Macau SAR China)
    const EN_MG = 'en_MG'; // English (Madagascar)
    const EN_MW = 'en_MW'; // English (Malawi)
    const EN_MY = 'en_MY'; // English (Malaysia)
    const EN_MT = 'en_MT'; // English (Malta)
    const EN_MH = 'en_MH'; // English (Marshall Islands)
    const EN_MU = 'en_MU'; // English (Mauritius)
    const EN_FM = 'en_FM'; // English (Micronesia)
    const EN_MS = 'en_MS'; // English (Montserrat)
    const EN_NA = 'en_NA'; // English (Namibia)
    const EN_NR = 'en_NR'; // English (Nauru)
    const EN_NZ = 'en_NZ'; // English (New Zealand)
    const EN_NG = 'en_NG'; // English (Nigeria)
    const EN_NU = 'en_NU'; // English (Niue)
    const EN_NF = 'en_NF'; // English (Norfolk Island)
    const EN_MP = 'en_MP'; // English (Northern Mariana Islands)
    const EN_PK = 'en_PK'; // English (Pakistan)
    const EN_PW = 'en_PW'; // English (Palau)
    const EN_PG = 'en_PG'; // English (Papua New Guinea)
    const EN_PH = 'en_PH'; // English (Philippines)
    const EN_PN = 'en_PN'; // English (Pitcairn Islands)
    const EN_PR = 'en_PR'; // English (Puerto Rico)
    const EN_RW = 'en_RW'; // English (Rwanda)
    const EN_WS = 'en_WS'; // English (Samoa)
    const EN_SC = 'en_SC'; // English (Seychelles)
    const EN_SL = 'en_SL'; // English (Sierra Leone)
    const EN_SG = 'en_SG'; // English (Singapore)
    const EN_SX = 'en_SX'; // English (Sint Maarten)
    const EN_SB = 'en_SB'; // English (Solomon Islands)
    const EN_ZA = 'en_ZA'; // English (South Africa)
    const EN_SS = 'en_SS'; // English (South Sudan)
    const EN_SH = 'en_SH'; // English (St. Helena)
    const EN_KN = 'en_KN'; // English (St. Kitts & Nevis)
    const EN_LC = 'en_LC'; // English (St. Lucia)
    const EN_VC = 'en_VC'; // English (St. Vincent & Grenadines)
    const EN_SD = 'en_SD'; // English (Sudan)
    const EN_SZ = 'en_SZ'; // English (Swaziland)
    const EN_TZ = 'en_TZ'; // English (Tanzania)
    const EN_TK = 'en_TK'; // English (Tokelau)
    const EN_TO = 'en_TO'; // English (Tonga)
    const EN_TT = 'en_TT'; // English (Trinidad & Tobago)
    const EN_TC = 'en_TC'; // English (Turks & Caicos Islands)
    const EN_TV = 'en_TV'; // English (Tuvalu)
    const EN_UM = 'en_UM'; // English (U.S. Outlying Islands)
    const EN_VI = 'en_VI'; // English (U.S. Virgin Islands)
    const EN_UG = 'en_UG'; // English (Uganda)
    const EN_GB = 'en_GB'; // English (United Kingdom)
    const EN_US = 'en_US'; // English (United States)
    const EN_VU = 'en_VU'; // English (Vanuatu)
    const EN_ZM = 'en_ZM'; // English (Zambia)
    const EN_ZW = 'en_ZW'; // English (Zimbabwe)
    const EO = 'eo'; // Esperanto
    const ET = 'et'; // Estonian
    const ET_EE = 'et_EE'; // Estonian (Estonia)
    const EE = 'ee'; // Ewe
    const EE_GH = 'ee_GH'; // Ewe (Ghana)
    const EE_TG = 'ee_TG'; // Ewe (Togo)
    const FO = 'fo'; // Faroese
    const FO_FO = 'fo_FO'; // Faroese (Faroe Islands)
    const FI = 'fi'; // Finnish
    const FI_FI = 'fi_FI'; // Finnish (Finland)
    const FR = 'fr'; // French
    const FR_DZ = 'fr_DZ'; // French (Algeria)
    const FR_BE = 'fr_BE'; // French (Belgium)
    const FR_BJ = 'fr_BJ'; // French (Benin)
    const FR_BF = 'fr_BF'; // French (Burkina Faso)
    const FR_BI = 'fr_BI'; // French (Burundi)
    const FR_CM = 'fr_CM'; // French (Cameroon)
    const FR_CA = 'fr_CA'; // French (Canada)
    const FR_CF = 'fr_CF'; // French (Central African Republic)
    const FR_TD = 'fr_TD'; // French (Chad)
    const FR_KM = 'fr_KM'; // French (Comoros)
    const FR_CG = 'fr_CG'; // French (Congo - Brazzaville)
    const FR_CD = 'fr_CD'; // French (Congo - Kinshasa)
    const FR_CI = 'fr_CI'; // French (Côte d’Ivoire)
    const FR_DJ = 'fr_DJ'; // French (Djibouti)
    const FR_GQ = 'fr_GQ'; // French (Equatorial Guinea)
    const FR_FR = 'fr_FR'; // French (France)
    const FR_GF = 'fr_GF'; // French (French Guiana)
    const FR_PF = 'fr_PF'; // French (French Polynesia)
    const FR_GA = 'fr_GA'; // French (Gabon)
    const FR_GP = 'fr_GP'; // French (Guadeloupe)
    const FR_GN = 'fr_GN'; // French (Guinea)
    const FR_HT = 'fr_HT'; // French (Haiti)
    const FR_LU = 'fr_LU'; // French (Luxembourg)
    const FR_MG = 'fr_MG'; // French (Madagascar)
    const FR_ML = 'fr_ML'; // French (Mali)
    const FR_MQ = 'fr_MQ'; // French (Martinique)
    const FR_MR = 'fr_MR'; // French (Mauritania)
    const FR_MU = 'fr_MU'; // French (Mauritius)
    const FR_YT = 'fr_YT'; // French (Mayotte)
    const FR_MC = 'fr_MC'; // French (Monaco)
    const FR_MA = 'fr_MA'; // French (Morocco)
    const FR_NC = 'fr_NC'; // French (New Caledonia)
    const FR_NE = 'fr_NE'; // French (Niger)
    const FR_RE = 'fr_RE'; // French (Réunion)
    const FR_RW = 'fr_RW'; // French (Rwanda)
    const FR_SN = 'fr_SN'; // French (Senegal)
    const FR_SC = 'fr_SC'; // French (Seychelles)
    const FR_BL = 'fr_BL'; // French (St. Barthélemy)
    const FR_MF = 'fr_MF'; // French (St. Martin)
    const FR_PM = 'fr_PM'; // French (St. Pierre & Miquelon)
    const FR_CH = 'fr_CH'; // French (Switzerland)
    const FR_SY = 'fr_SY'; // French (Syria)
    const FR_TG = 'fr_TG'; // French (Togo)
    const FR_TN = 'fr_TN'; // French (Tunisia)
    const FR_VU = 'fr_VU'; // French (Vanuatu)
    const FR_WF = 'fr_WF'; // French (Wallis & Futuna)
    const FF = 'ff'; // Fulah
    const FF_CM = 'ff_CM'; // Fulah (Cameroon)
    const FF_GN = 'ff_GN'; // Fulah (Guinea)
    const FF_MR = 'ff_MR'; // Fulah (Mauritania)
    const FF_SN = 'ff_SN'; // Fulah (Senegal)
    const GL = 'gl'; // Galician
    const GL_ES = 'gl_ES'; // Galician (Spain)
    const LG = 'lg'; // Ganda
    const LG_UG = 'lg_UG'; // Ganda (Uganda)
    const KA = 'ka'; // Georgian
    const KA_GE = 'ka_GE'; // Georgian (Georgia)
    const DE = 'de'; // German
    const DE_AT = 'de_AT'; // German (Austria)
    const DE_BE = 'de_BE'; // German (Belgium)
    const DE_DE = 'de_DE'; // German (Germany)
    const DE_LI = 'de_LI'; // German (Liechtenstein)
    const DE_LU = 'de_LU'; // German (Luxembourg)
    const DE_CH = 'de_CH'; // German (Switzerland)
    const EL = 'el'; // Greek
    const EL_CY = 'el_CY'; // Greek (Cyprus)
    const EL_GR = 'el_GR'; // Greek (Greece)
    const GU = 'gu'; // Gujarati
    const GU_IN = 'gu_IN'; // Gujarati (India)
    const HA = 'ha'; // Hausa
    const HA_GH = 'ha_GH'; // Hausa (Ghana)
    const HA_LATN_GH = 'ha_Latn_GH'; // Hausa (Latin, Ghana)
    const HA_LATN_NE = 'ha_Latn_NE'; // Hausa (Latin, Niger)
    const HA_LATN_NG = 'ha_Latn_NG'; // Hausa (Latin, Nigeria)
    const HA_LATN = 'ha_Latn'; // Hausa (Latin)
    const HA_NE = 'ha_NE'; // Hausa (Niger)
    const HA_NG = 'ha_NG'; // Hausa (Nigeria)
    const HE = 'he'; // Hebrew
    const HE_IL = 'he_IL'; // Hebrew (Israel)
    const HI = 'hi'; // Hindi
    const HI_IN = 'hi_IN'; // Hindi (India)
    const HU = 'hu'; // Hungarian
    const HU_HU = 'hu_HU'; // Hungarian (Hungary)
    const IS = 'is'; // Icelandic
    const IS_IS = 'is_IS'; // Icelandic (Iceland)
    const IG = 'ig'; // Igbo
    const IG_NG = 'ig_NG'; // Igbo (Nigeria)
    const ID = 'id'; // Indonesian
    const ID_ID = 'id_ID'; // Indonesian (Indonesia)
    const GA = 'ga'; // Irish
    const GA_IE = 'ga_IE'; // Irish (Ireland)
    const IT = 'it'; // Italian
    const IT_IT = 'it_IT'; // Italian (Italy)
    const IT_SM = 'it_SM'; // Italian (San Marino)
    const IT_CH = 'it_CH'; // Italian (Switzerland)
    const JA = 'ja'; // Japanese
    const JA_JP = 'ja_JP'; // Japanese (Japan)
    const KL = 'kl'; // Kalaallisut
    const KL_GL = 'kl_GL'; // Kalaallisut (Greenland)
    const KN = 'kn'; // Kannada
    const KN_IN = 'kn_IN'; // Kannada (India)
    const KS = 'ks'; // Kashmiri
    const KS_ARAB_IN = 'ks_Arab_IN'; // Kashmiri (Arabic, India)
    const KS_ARAB = 'ks_Arab'; // Kashmiri (Arabic)
    const KS_IN = 'ks_IN'; // Kashmiri (India)
    const KK = 'kk'; // Kazakh
    const KK_CYRL_KZ = 'kk_Cyrl_KZ'; // Kazakh (Cyrillic, Kazakhstan)
    const KK_CYRL = 'kk_Cyrl'; // Kazakh (Cyrillic)
    const KK_KZ = 'kk_KZ'; // Kazakh (Kazakhstan)
    const KM = 'km'; // Khmer
    const KM_KH = 'km_KH'; // Khmer (Cambodia)
    const KI = 'ki'; // Kikuyu
    const KI_KE = 'ki_KE'; // Kikuyu (Kenya)
    const RW = 'rw'; // Kinyarwanda
    const RW_RW = 'rw_RW'; // Kinyarwanda (Rwanda)
    const KO = 'ko'; // Korean
    const KO_KP = 'ko_KP'; // Korean (North Korea)
    const KO_KR = 'ko_KR'; // Korean (South Korea)
    const KY = 'ky'; // Kyrgyz
    const KY_CYRL_KG = 'ky_Cyrl_KG'; // Kyrgyz (Cyrillic, Kyrgyzstan)
    const KY_CYRL = 'ky_Cyrl'; // Kyrgyz (Cyrillic)
    const KY_KG = 'ky_KG'; // Kyrgyz (Kyrgyzstan)
    const LO = 'lo'; // Lao
    const LO_LA = 'lo_LA'; // Lao (Laos)
    const LV = 'lv'; // Latvian
    const LV_LV = 'lv_LV'; // Latvian (Latvia)
    const LN = 'ln'; // Lingala
    const LN_AO = 'ln_AO'; // Lingala (Angola)
    const LN_CF = 'ln_CF'; // Lingala (Central African Republic)
    const LN_CG = 'ln_CG'; // Lingala (Congo - Brazzaville)
    const LN_CD = 'ln_CD'; // Lingala (Congo - Kinshasa)
    const LT = 'lt'; // Lithuanian
    const LT_LT = 'lt_LT'; // Lithuanian (Lithuania)
    const LU = 'lu'; // Luba-Katanga
    const LU_CD = 'lu_CD'; // Luba-Katanga (Congo - Kinshasa)
    const LB = 'lb'; // Luxembourgish
    const LB_LU = 'lb_LU'; // Luxembourgish (Luxembourg)
    const MK = 'mk'; // Macedonian
    const MK_MK = 'mk_MK'; // Macedonian (Macedonia)
    const MG = 'mg'; // Malagasy
    const MG_MG = 'mg_MG'; // Malagasy (Madagascar)
    const MS = 'ms'; // Malay
    const MS_BN = 'ms_BN'; // Malay (Brunei)
    const MS_LATN_BN = 'ms_Latn_BN'; // Malay (Latin, Brunei)
    const MS_LATN_MY = 'ms_Latn_MY'; // Malay (Latin, Malaysia)
    const MS_LATN_SG = 'ms_Latn_SG'; // Malay (Latin, Singapore)
    const MS_LATN = 'ms_Latn'; // Malay (Latin)
    const MS_MY = 'ms_MY'; // Malay (Malaysia)
    const MS_SG = 'ms_SG'; // Malay (Singapore)
    const ML = 'ml'; // Malayalam
    const ML_IN = 'ml_IN'; // Malayalam (India)
    const MT = 'mt'; // Maltese
    const MT_MT = 'mt_MT'; // Maltese (Malta)
    const GV = 'gv'; // Manx
    const GV_IM = 'gv_IM'; // Manx (Isle of Man)
    const MR = 'mr'; // Marathi
    const MR_IN = 'mr_IN'; // Marathi (India)
    const MN = 'mn'; // Mongolian
    const MN_CYRL_MN = 'mn_Cyrl_MN'; // Mongolian (Cyrillic, Mongolia)
    const MN_CYRL = 'mn_Cyrl'; // Mongolian (Cyrillic)
    const MN_MN = 'mn_MN'; // Mongolian (Mongolia)
    const NE = 'ne'; // Nepali
    const NE_IN = 'ne_IN'; // Nepali (India)
    const NE_NP = 'ne_NP'; // Nepali (Nepal)
    const ND = 'nd'; // North Ndebele
    const ND_ZW = 'nd_ZW'; // North Ndebele (Zimbabwe)
    const SE = 'se'; // Northern Sami
    const SE_FI = 'se_FI'; // Northern Sami (Finland)
    const SE_NO = 'se_NO'; // Northern Sami (Norway)
    const SE_SE = 'se_SE'; // Northern Sami (Sweden)
    const NO = 'no'; // Norwegian
    const NO_NO = 'no_NO'; // Norwegian (Norway)
    const NB = 'nb'; // Norwegian Bokmål
    const NB_NO = 'nb_NO'; // Norwegian Bokmål (Norway)
    const NB_SJ = 'nb_SJ'; // Norwegian Bokmål (Svalbard & Jan Mayen)
    const NN = 'nn'; // Norwegian Nynorsk
    const NN_NO = 'nn_NO'; // Norwegian Nynorsk (Norway)
    const OR_ = 'or'; // Oriya
    const OR_IN = 'or_IN'; // Oriya (India)
    const OM = 'om'; // Oromo
    const OM_ET = 'om_ET'; // Oromo (Ethiopia)
    const OM_KE = 'om_KE'; // Oromo (Kenya)
    const OS = 'os'; // Ossetic
    const OS_GE = 'os_GE'; // Ossetic (Georgia)
    const OS_RU = 'os_RU'; // Ossetic (Russia)
    const PS = 'ps'; // Pashto
    const PS_AF = 'ps_AF'; // Pashto (Afghanistan)
    const FA = 'fa'; // Persian
    const FA_AF = 'fa_AF'; // Persian (Afghanistan)
    const FA_IR = 'fa_IR'; // Persian (Iran)
    const PL = 'pl'; // Polish
    const PL_PL = 'pl_PL'; // Polish (Poland)
    const PT = 'pt'; // Portuguese
    const PT_AO = 'pt_AO'; // Portuguese (Angola)
    const PT_BR = 'pt_BR'; // Portuguese (Brazil)
    const PT_CV = 'pt_CV'; // Portuguese (Cape Verde)
    const PT_GW = 'pt_GW'; // Portuguese (Guinea-Bissau)
    const PT_MO = 'pt_MO'; // Portuguese (Macau SAR China)
    const PT_MZ = 'pt_MZ'; // Portuguese (Mozambique)
    const PT_PT = 'pt_PT'; // Portuguese (Portugal)
    const PT_ST = 'pt_ST'; // Portuguese (São Tomé & Príncipe)
    const PT_TL = 'pt_TL'; // Portuguese (Timor-Leste)
    const PA = 'pa'; // Punjabi
    const PA_ARAB_PK = 'pa_Arab_PK'; // Punjabi (Arabic, Pakistan)
    const PA_ARAB = 'pa_Arab'; // Punjabi (Arabic)
    const PA_GURU_IN = 'pa_Guru_IN'; // Punjabi (Gurmukhi, India)
    const PA_GURU = 'pa_Guru'; // Punjabi (Gurmukhi)
    const PA_IN = 'pa_IN'; // Punjabi (India)
    const PA_PK = 'pa_PK'; // Punjabi (Pakistan)
    const QU = 'qu'; // Quechua
    const QU_BO = 'qu_BO'; // Quechua (Bolivia)
    const QU_EC = 'qu_EC'; // Quechua (Ecuador)
    const QU_PE = 'qu_PE'; // Quechua (Peru)
    const RO = 'ro'; // Romanian
    const RO_MD = 'ro_MD'; // Romanian (Moldova)
    const RO_RO = 'ro_RO'; // Romanian (Romania)
    const RM = 'rm'; // Romansh
    const RM_CH = 'rm_CH'; // Romansh (Switzerland)
    const RN = 'rn'; // Rundi
    const RN_BI = 'rn_BI'; // Rundi (Burundi)
    const RU = 'ru'; // Russian
    const RU_BY = 'ru_BY'; // Russian (Belarus)
    const RU_KZ = 'ru_KZ'; // Russian (Kazakhstan)
    const RU_KG = 'ru_KG'; // Russian (Kyrgyzstan)
    const RU_MD = 'ru_MD'; // Russian (Moldova)
    const RU_RU = 'ru_RU'; // Russian (Russia)
    const RU_UA = 'ru_UA'; // Russian (Ukraine)
    const SG = 'sg'; // Sango
    const SG_CF = 'sg_CF'; // Sango (Central African Republic)
    const GD = 'gd'; // Scottish Gaelic
    const GD_GB = 'gd_GB'; // Scottish Gaelic (United Kingdom)
    const SR = 'sr'; // Serbian
    const SR_BA = 'sr_BA'; // Serbian (Bosnia & Herzegovina)
    const SR_CYRL_BA = 'sr_Cyrl_BA'; // Serbian (Cyrillic, Bosnia & Herzegovina)
    const SR_CYRL_XK = 'sr_Cyrl_XK'; // Serbian (Cyrillic, Kosovo)
    const SR_CYRL_ME = 'sr_Cyrl_ME'; // Serbian (Cyrillic, Montenegro)
    const SR_CYRL_RS = 'sr_Cyrl_RS'; // Serbian (Cyrillic, Serbia)
    const SR_CYRL = 'sr_Cyrl'; // Serbian (Cyrillic)
    const SR_XK = 'sr_XK'; // Serbian (Kosovo)
    const SR_LATN_BA = 'sr_Latn_BA'; // Serbian (Latin, Bosnia & Herzegovina)
    const SR_LATN_XK = 'sr_Latn_XK'; // Serbian (Latin, Kosovo)
    const SR_LATN_ME = 'sr_Latn_ME'; // Serbian (Latin, Montenegro)
    const SR_LATN_RS = 'sr_Latn_RS'; // Serbian (Latin, Serbia)
    const SR_LATN = 'sr_Latn'; // Serbian (Latin)
    const SR_ME = 'sr_ME'; // Serbian (Montenegro)
    const SR_RS = 'sr_RS'; // Serbian (Serbia)
    const SH = 'sh'; // Serbo-Croatian
    const SH_BA = 'sh_BA'; // Serbo-Croatian (Bosnia & Herzegovina)
    const SN = 'sn'; // Shona
    const SN_ZW = 'sn_ZW'; // Shona (Zimbabwe)
    const II = 'ii'; // Sichuan Yi
    const II_CN = 'ii_CN'; // Sichuan Yi (China)
    const SI = 'si'; // Sinhala
    const SI_LK = 'si_LK'; // Sinhala (Sri Lanka)
    const SK = 'sk'; // Slovak
    const SK_SK = 'sk_SK'; // Slovak (Slovakia)
    const SL = 'sl'; // Slovenian
    const SL_SI = 'sl_SI'; // Slovenian (Slovenia)
    const SO = 'so'; // Somali
    const SO_DJ = 'so_DJ'; // Somali (Djibouti)
    const SO_ET = 'so_ET'; // Somali (Ethiopia)
    const SO_KE = 'so_KE'; // Somali (Kenya)
    const SO_SO = 'so_SO'; // Somali (Somalia)
    const ES = 'es'; // Spanish
    const ES_AR = 'es_AR'; // Spanish (Argentina)
    const ES_BO = 'es_BO'; // Spanish (Bolivia)
    const ES_IC = 'es_IC'; // Spanish (Canary Islands)
    const ES_EA = 'es_EA'; // Spanish (Ceuta & Melilla)
    const ES_CL = 'es_CL'; // Spanish (Chile)
    const ES_CO = 'es_CO'; // Spanish (Colombia)
    const ES_CR = 'es_CR'; // Spanish (Costa Rica)
    const ES_CU = 'es_CU'; // Spanish (Cuba)
    const ES_DO = 'es_DO'; // Spanish (Dominican Republic)
    const ES_EC = 'es_EC'; // Spanish (Ecuador)
    const ES_SV = 'es_SV'; // Spanish (El Salvador)
    const ES_GQ = 'es_GQ'; // Spanish (Equatorial Guinea)
    const ES_GT = 'es_GT'; // Spanish (Guatemala)
    const ES_HN = 'es_HN'; // Spanish (Honduras)
    const ES_MX = 'es_MX'; // Spanish (Mexico)
    const ES_NI = 'es_NI'; // Spanish (Nicaragua)
    const ES_PA = 'es_PA'; // Spanish (Panama)
    const ES_PY = 'es_PY'; // Spanish (Paraguay)
    const ES_PE = 'es_PE'; // Spanish (Peru)
    const ES_PH = 'es_PH'; // Spanish (Philippines)
    const ES_PR = 'es_PR'; // Spanish (Puerto Rico)
    const ES_ES = 'es_ES'; // Spanish (Spain)
    const ES_US = 'es_US'; // Spanish (United States)
    const ES_UY = 'es_UY'; // Spanish (Uruguay)
    const ES_VE = 'es_VE'; // Spanish (Venezuela)
    const SW = 'sw'; // Swahili
    const SW_KE = 'sw_KE'; // Swahili (Kenya)
    const SW_TZ = 'sw_TZ'; // Swahili (Tanzania)
    const SW_UG = 'sw_UG'; // Swahili (Uganda)
    const SV = 'sv'; // Swedish
    const SV_AX = 'sv_AX'; // Swedish (Åland Islands)
    const SV_FI = 'sv_FI'; // Swedish (Finland)
    const SV_SE = 'sv_SE'; // Swedish (Sweden)
    const TL = 'tl'; // Tagalog
    const TL_PH = 'tl_PH'; // Tagalog (Philippines)
    const TA = 'ta'; // Tamil
    const TA_IN = 'ta_IN'; // Tamil (India)
    const TA_MY = 'ta_MY'; // Tamil (Malaysia)
    const TA_SG = 'ta_SG'; // Tamil (Singapore)
    const TA_LK = 'ta_LK'; // Tamil (Sri Lanka)
    const TE = 'te'; // Telugu
    const TE_IN = 'te_IN'; // Telugu (India)
    const TH = 'th'; // Thai
    const TH_TH = 'th_TH'; // Thai (Thailand)
    const BO = 'bo'; // Tibetan
    const BO_CN = 'bo_CN'; // Tibetan (China)
    const BO_IN = 'bo_IN'; // Tibetan (India)
    const TI = 'ti'; // Tigrinya
    const TI_ER = 'ti_ER'; // Tigrinya (Eritrea)
    const TI_ET = 'ti_ET'; // Tigrinya (Ethiopia)
    const TO = 'to'; // Tongan
    const TO_TO = 'to_TO'; // Tongan (Tonga)
    const TR = 'tr'; // Turkish
    const TR_CY = 'tr_CY'; // Turkish (Cyprus)
    const TR_TR = 'tr_TR'; // Turkish (Turkey)
    const UK = 'uk'; // Ukrainian
    const UK_UA = 'uk_UA'; // Ukrainian (Ukraine)
    const UR = 'ur'; // Urdu
    const UR_IN = 'ur_IN'; // Urdu (India)
    const UR_PK = 'ur_PK'; // Urdu (Pakistan)
    const UG = 'ug'; // Uyghur
    const UG_ARAB_CN = 'ug_Arab_CN'; // Uyghur (Arabic, China)
    const UG_ARAB = 'ug_Arab'; // Uyghur (Arabic)
    const UG_CN = 'ug_CN'; // Uyghur (China)
    const UZ = 'uz'; // Uzbek
    const UZ_AF = 'uz_AF'; // Uzbek (Afghanistan)
    const UZ_ARAB_AF = 'uz_Arab_AF'; // Uzbek (Arabic, Afghanistan)
    const UZ_ARAB = 'uz_Arab'; // Uzbek (Arabic)
    const UZ_CYRL_UZ = 'uz_Cyrl_UZ'; // Uzbek (Cyrillic, Uzbekistan)
    const UZ_CYRL = 'uz_Cyrl'; // Uzbek (Cyrillic)
    const UZ_LATN_UZ = 'uz_Latn_UZ'; // Uzbek (Latin, Uzbekistan)
    const UZ_LATN = 'uz_Latn'; // Uzbek (Latin)
    const UZ_UZ = 'uz_UZ'; // Uzbek (Uzbekistan)
    const VI = 'vi'; // Vietnamese
    const VI_VN = 'vi_VN'; // Vietnamese (Vietnam)
    const CY = 'cy'; // Welsh
    const CY_GB = 'cy_GB'; // Welsh (United Kingdom)
    const FY = 'fy'; // Western Frisian
    const FY_NL = 'fy_NL'; // Western Frisian (Netherlands)
    const YI = 'yi'; // Yiddish
    const YO = 'yo'; // Yoruba
    const YO_BJ = 'yo_BJ'; // Yoruba (Benin)
    const YO_NG = 'yo_NG'; // Yoruba (Nigeria)
    const ZU = 'zu'; // Zulu
    const ZU_ZA = 'zu_ZA'; // Zulu (South Africa)
}

/*EOF*/
