<?php

namespace DealerDirect\Generic\Util;

/**
 * Class URIUtil
 *
 * URI/URL Helper Utils
 *
 * @package DealerDirect\Generic\Util
 */
class URIUtil
{
    /**
     * Normalize a Locale value to valid URL encoded string
     *
     * Usually returns only language part of Locale as string, but in case of Belgian Territory,
     * language with territory is returned combined.
     *
     * For example:
     *  - Locale 'nl_NL' results in 'nl'
     *  - Locale 'nl_BE' results in 'nl-be'
     *  - Locale 'fr_BE' results in 'fr-be'
     *  - Locale 'fr_FR' results in 'fr'
     *
     * @param Locale|string $locale
     *
     * @return string
     */
    public static function normalizeLocale($locale)
    {
        if (!is_string($locale)) {
            $locale = (string)$locale;
        }
        $localeParts = explode('_', strtolower($locale));
        if ($localeParts[1] === 'be') {
            // In case of Belgian Locale, return language and country combined
            return sprintf('%s-%s', $localeParts[0], $localeParts[1]);
        }
        return $localeParts[0];
    }
}
