# DealerDirect Generic PHP

## Introduction

Generic PHP classes and functionality that can be used across all of the PHP
projects within DealerDirect.

### Installation

The preferred means of installing this code is by adding it as a Composer
dependency to a project. This is done by adding this repository to a project's 
`composer.json` file:

    {
        "repositories": [
            {
                "type": "git",
                "url": "git@git.dealerdirect.io:php-packages/dealerdirect-generic-php.git"
            }
        ]
    }

And then adding this project as a composer dependency:

    composer require 'dealerdirect/generic'

## Usage

This package offers two sorts of behaviour:

1. Concrete classes
2. Abstract classes and interfaces

### Concrete classes

The concrete classes this package offers fall into two categories: 

**Repository classes** can be instantiated to have objects in which concrete values can be stored.

**Category classes** can not be instantiated. They are meant as a definition of which values **Repository objects** may contain.

### Abstract classes and interfaces

The following abstract classes and interfaces are available:

- **`DealerDirect\Generic\Category\AbstractEnum`**  
  This class is meant to be extend by classes that constants should be stored in _but nothing else_.
- **`DealerDirect\Generic\Config\AbstractConfig`**  
  This class is meant to be extend by classes to hold project specific configuration key/value pairs. 
- **`DealerDirect\Generic\Repository\RepositoryInterface`**  
  Interface for classes that should function purely as Data-Container/Immutable object.

### A word on hard-coded values, magic numbers and database id's.

The code of various Dealerdirect applications contains a lot of hard-coded values,
magic numbers and direct references to id's in databases.

Eventually, when all hard-coded values and magic numbers have been successfully
herded together, they can/should be moved to a database and removed from the
code-base. All such information would then only live in instances of **Entity
classes**.

To clean up the code in all of the applications, an interim solution is needed.
This solution needs to make a clear separation between which data is available
and objects in which such data is stored.

To have Objects in which concrete values can be stored **Repository classes** have
been created. In order to validate the data that goes into such objects, **Category
classes** have been created that contain the available values which **Repository
objects** may contain

When all of the hard-coded values, magic numbers and id references have been
moved to a database, the **Category classes** can be deprecated and, instead of
using **Repository classes** to hold scalar values, the Repositories should
contain/return **Entity objects** that have been populated from the database.

## Diagrams

### Categories Classes (Enums)

![](./docs/Generic Category Enums.png)

### Repositories Classes

![](./docs/Generic Repository Classes.png)
