<?php

use DealerDirect\Generic\Category\CallStatus;
use DealerDirect\Generic\Category\Color;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\DamageFree;
use DealerDirect\Generic\Category\DistanceUnit;
use DealerDirect\Generic\Category\Driveable;
use DealerDirect\Generic\Category\EnginePower;
use DealerDirect\Generic\Category\Fuel;
use DealerDirect\Generic\Category\LacquerTint;
use DealerDirect\Generic\Category\OldNewModel;
use DealerDirect\Generic\Category\PaintworkType;
use DealerDirect\Generic\Category\ServiceHistoryBooklet;
use DealerDirect\Generic\Category\ValueAddedTax;

return [
    'callstatus' => [
        CallStatus::BEING_PROCESSED => 'in behandeling',
        CallStatus::CALL_AGAIN => 'opnieuw bellen',
        CallStatus::CALL_BACK_AFTER_AUCTION => 'na veiling terugbellen',
        CallStatus::CALL_DIRECT => 'direct bellen',
        CallStatus::CALLED => 'gebeld',
        CallStatus::LEFT_VOICE_MAIL_MESSAGE => 'voicemail ingesproken',
        CallStatus::LOT_DISCUSSED_WITH_CONSUMER => 'kavel doorgenomen',
        CallStatus::NO_ANSWER => 'geen gehoor',
        CallStatus::LEAVING_SERVICE => 'uitgeschreven',
        CallStatus::REACTIVATED => 'opnieuw geactiveerd',
        CallStatus::REQUEST_CONTACT_INFORMATION => 'verzoek contact gegevens',
        CallStatus::RESPECT_THE_CHANNEL => 'RTC',
        CallStatus::SOLD_BY_CONSUMER => 'zelf verkocht',
        CallStatus::SOLD_UNDER_OTHER_LOT => 'verkocht op andere kavel',
        CallStatus::TURBO_AUCTION => 'turboveiling',
        CallStatus::FAKE => 'nep aanmelding',
        CallStatus::DUPLICATE => 'duplicaat voertuig',
        CallStatus::CALL_BACK_APPOINTMENT => 'terugbelafspraak',
        CallStatus::PUT_THROUGH => 'doorverbonden'
    ],
    'color' => [
        Color::UNKNOWN => 'Onbekend',
        Color::BEIGE => 'Beige',
        Color::BLUE => 'Blauw',
        Color::GREEN => 'Groen',
        Color::BROWN => 'Bruin',
        Color::YELLOW => 'Geel',
        Color::GRAY => 'Grijs',
        Color::ORANGE => 'Oranje',
        Color::PURPLE => 'Paars',
        Color::RED => 'Rood',
        Color::PINK => 'Rose',
        Color::WHITE => 'Wit',
        Color::SILVER_GRAY => 'Zilvergrijs',
        Color::BLACK => 'Zwart'
    ],
    'country' => [
        Country::NETHERLANDS => 'Nederland',
        Country::BELGIUM => 'België',
        Country::GERMANY => 'Duitsland',
        Country::FRANCE => 'Frankrijk',
        Country::SWEDEN => 'Zweden',
        Country::DENMARK => 'Denemarken',
        Country::NORWAY => 'Noorwegen',
        Country::POLAND => 'Polen',
        Country::AUSTRIA => 'Oostenrijk',
        Country::LUXEMBOURG => 'Luxemburg',
        Country::SWITZERLAND => 'Zwitserland'
    ],
    'damageFree' => [
        DamageFree::NO => 'Nee',
        DamageFree::YES => 'Ja',
        DamageFree::UNKNOWN => 'Onbekend',
    ],
    'distanceunit' => [
        DistanceUnit::NOT_SPECIFIED => 'km',
        DistanceUnit::KM => 'km',
        DistanceUnit::MILES => 'mijlen',
    ],
    'driveable' => [
        Driveable::UNKNOWN => 'Kies...',
        Driveable::NO => 'Nee',
        Driveable::YES => 'Ja',
    ],
    'enginepower' => [
        EnginePower::UNIT_KW => 'kW',
        EnginePower::UNIT_HP => 'PK'
    ],
    'fuel' => [
        Fuel::UNKNOWN => 'Onbekend',
        Fuel::GASOLINE => 'Benzine',
        Fuel::DIESEL => 'Diesel',
        Fuel::ELECTRICITY => 'Electriciteit',
        Fuel::LPG => 'LPG',
        Fuel::LPG_G3 => 'LPG-G3',
        Fuel::CRYOGENIC => 'Cryogeen',
        Fuel::CNG => 'CNG',
        Fuel::HYDROGEN => 'Waterstof',
        Fuel::HYBRID_GASOLINE => 'Hybride-Benzine',
        Fuel::HYBRID_DIESEL => 'Hybride-Diesel',
        Fuel::HYBRID_GASOLINE_LPG => 'Hybride-Benzine-LPG',
    ],
    'serviceHistoryBooklet' => [
        ServiceHistoryBooklet::UNKNOWN => 'Kies...',
        ServiceHistoryBooklet::NO => 'Nee',
        ServiceHistoryBooklet::YES => 'Ja',
    ],
    'paintworktype' => [
        PaintworkType::UNKNOWN => 'Onbekend',
        PaintworkType::REGULAR => 'Gewone lak',
        PaintworkType::METALLIC => 'Metallic lak',
        PaintworkType::PEARL => 'Pareleffect',
    ],
    'oldNewModel' => [
        OldNewModel::UNKNOWN => 'Kies...',
        OldNewModel::NEW => 'Nieuw',
        OldNewModel::OLD => 'Oud'
    ],
    'lacquerTint' => [
        LacquerTint::UNKNOWN => 'Onbekend',
        LacquerTint::LIGHT => 'Licht',
        LacquerTint::MIDDLE => 'Midden',
        LacquerTint::DARK => 'Donker',
    ],
    'valueaddedtax' => [
        ValueAddedTax::UNKNOWN => 'Onbekend',
        ValueAddedTax::UNKNOWN_3 => 'Onbekend(3)',
        ValueAddedTax::DEDUCTIBLE => 'BTW',
        ValueAddedTax::NON_DEDUCTIBLE => 'Marge'
    ]
];
