<?php

namespace DealerDirect\Generic\Repository;

use Dealerdirect\Generic\AbstractTestCase;
use DealerDirect\Generic\Category\Locale as LocaleCategory;

/**
 * @coversDefaultClass DealerDirect\Generic\Repository\Locale
 */
class LocaleTest extends AbstractTestCase
{
    /**
     * @param $language
     * @param $country
     * @param $expectedLocaleString
     *
     * @covers ::__construct
     * @covers ::__toString
     * @covers ::getLanguage
     * @covers ::getTerritory
     *
     * @dataProvider provideLanguageAndCountryCodes
     */
    public function testCreatedLocaleShouldBeCorrectlyCastAsString($language, $country, $expectedLocaleString)
    {
        $locale = new Locale($language, $country);
        $localeString = (string)$locale;
        self::assertEquals($expectedLocaleString, $localeString);
    }

    /**
     * @param $language
     * @param $country
     * @param $expectedLocale
     *
     * @covers ::fromString
     * @covers ::__construct
     * @covers ::__toString
     * @covers ::getLanguage
     * @covers ::getTerritory
     *
     * @dataProvider provideLanguageAndCountryCodes
     */
    public function testLocaleShouldBeCorrectlyCreatedFromString($language, $country, $expectedLocale)
    {
        $localeString = $language . '_' . $country;
        $locale = Locale::fromString($localeString);

        self::assertEquals($expectedLocale, (string)$locale);
    }

    /**
     *
     * @covers ::fromString
     *
     */
    public function testCreateLocaleFromInvalidStringShouldThrowInvalidArgumentException()
    {
        $this->expectException('InvalidArgumentException');
        Locale::fromString('nl-Nl');
    }

    /**
     * @return array[] Returns 3 dim-arrays with values: {LanguageId, CountryId, ExpectedLocale}
     */
    public static function provideLanguageAndCountryCodes()
    {
        return [
            ['nl', 'NL', LocaleCategory::NL_NL],
            ['nl', 'BE', LocaleCategory::NL_BE],
            ['fr', 'BE', LocaleCategory::FR_BE],
            ['fr', 'FR', LocaleCategory::FR_FR],
            ['de', 'DE', LocaleCategory::DE_DE],
        ];
    }
}
