<?php
use DealerDirect\Generic\Category\Upholstery;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Category\VehicleTypeCarBodyType;
use DealerDirect\Generic\Category\VehicleTypeMotorBodyType;
use DealerDirect\Generic\Category\VehicleTypeCarCondition;
use DealerDirect\Generic\Category\VehicleTypeMotorCondition;
use DealerDirect\Generic\Category\VehicleTypeCarTransmission;
use DealerDirect\Generic\Category\VehicleTypeMotorTransmission;

return [
    'default' => 'Onbekend',
    VehicleType::CAR => [
        'bodytype' => [
            VehicleTypeCarBodyType::UNKNOWN => 'Onbekend',
            VehicleTypeCarBodyType::THREE_DOOR_HATCHBACK => '3-deurs Hatchback',
            VehicleTypeCarBodyType::FOUR_DOOR_SALOON => '4-deurs Sedan',
            VehicleTypeCarBodyType::FIVE_DOOR_HATCHBACK => '5-deurs Hatchback',
            VehicleTypeCarBodyType::MPV => 'Monovolume',
            VehicleTypeCarBodyType::PASSENGER_BUS => 'Bus',
            VehicleTypeCarBodyType::SUV_CROSSOVER => 'SUV / Crossover',
            VehicleTypeCarBodyType::STATION => 'Break',
            VehicleTypeCarBodyType::CONVERTIBLE => 'Cabrio',
            VehicleTypeCarBodyType::COUPE => 'Coupé',
            VehicleTypeCarBodyType::CROSS_COUNTRY => 'Terreinwagen',
            VehicleTypeCarBodyType::VAN_SINGLE_CABIN => 'Lichte vracht enkele cabine',
            VehicleTypeCarBodyType::VAN_DOUBLE_CABIN => 'Lichte vracht dubbele cabine',
            VehicleTypeCarBodyType::TRUCK => 'Vrachtwagen',
            VehicleTypeCarBodyType::PICKUP => 'Pickup',
            VehicleTypeCarBodyType::CAMPER => 'Motorhome',
            VehicleTypeCarBodyType::CARAVAN => 'Caravan',
            VehicleTypeCarBodyType::TRAILER => 'Aanhanger',
            VehicleTypeCarBodyType::FOLDING_CARAVAN => 'Vouwwagen',
            VehicleTypeCarBodyType::MICROCAR => '45 km auto',
            // DEPRECATED:
            // VehicleTypeCarBodyType::CC_CONVERTIBLE_COUPE => 'CC: Cabriolet & Coupe',
            // VehicleTypeCarBodyType::TWO_DOOR_HATCHBACK => '2-deurs Hatchback',
            // VehicleTypeCarBodyType::TWO_DOOR_SALOON => '2-deurs Sedan',
        ],
        'condition' => [
            VehicleTypeCarCondition::UNKNOWN => 'Onbekend',
            VehicleTypeCarCondition::AS_NEW => 'Nieuwstaat',
            VehicleTypeCarCondition::GOOD => 'Goed',
            VehicleTypeCarCondition::AVERAGE => 'Redelijk',
            VehicleTypeCarCondition::BAD => 'Slecht'
        ],
        'transmission' => [
            VehicleTypeCarTransmission::UNKNOWN => 'Onbekend',
            VehicleTypeCarTransmission::MANUAL => 'Handgeschakeld',
            VehicleTypeCarTransmission::AUTOMATIC => 'Automaat',
            VehicleTypeCarTransmission::SEMI_AUTOMATIC => 'Half-Automaat'
        ],
        'upholstery' => [
            Upholstery::UNKNOWN => 'Onbekend',
            Upholstery::ALCANTARA => 'Alcantara',
            Upholstery::CLOTH => 'Stof',
            Upholstery::SEMI_LEATHER => 'Half-leder',
            Upholstery::LEATHER => 'Leder',
            Upholstery::LEATHERETTE => 'Skai/Kunstleer'
        ]
    ],
    VehicleType::MOTOR => [
        'bodytype' => [
            VehicleTypeMotorBodyType::UNKNOWN => 'Onbekend',
            VehicleTypeMotorBodyType::ALL_ROAD => 'All road',
            VehicleTypeMotorBodyType::CUSTOM => 'Custom',
            VehicleTypeMotorBodyType::CROSS => 'Cross',
            VehicleTypeMotorBodyType::ENDURO => 'Enduro',
            VehicleTypeMotorBodyType::NAKED => 'Naked',
            VehicleTypeMotorBodyType::RACE => 'Race',
            VehicleTypeMotorBodyType::SUPER_SPORT => 'Supersport',
            VehicleTypeMotorBodyType::SPORT_TOURING => 'Sport-toer',
            VehicleTypeMotorBodyType::MOTOR_SCOOTER => 'Scooter',
            VehicleTypeMotorBodyType::SUPER_MOTO => 'Supermotard',
            VehicleTypeMotorBodyType::TOURING => 'Toer',
            VehicleTypeMotorBodyType::SIDE_CAR => 'Zijspan',
            VehicleTypeMotorBodyType::TRIKE => 'Trike',
            VehicleTypeMotorBodyType::CLASSIC => 'Klassieker',
            VehicleTypeMotorBodyType::QUAD => 'Quad',
            VehicleTypeMotorBodyType::MOPED_25 => 'Snorfiets',
            VehicleTypeMotorBodyType::MOPED_45 => 'Bromfiets',
            VehicleTypeMotorBodyType::TRIAL => 'Trial',
            VehicleTypeMotorBodyType::MICROCAR => '45 km auto',
        ],
        'condition' => [
            VehicleTypeMotorCondition::UNKNOWN => 'Onbekend',
            VehicleTypeMotorCondition::AS_NEW => 'Nieuwstaat',
            VehicleTypeMotorCondition::GOOD => 'Goed',
            VehicleTypeMotorCondition::AVERAGE => 'Redelijk',
            VehicleTypeMotorCondition::POOR => 'Matig',
            VehicleTypeMotorCondition::BAD => 'Slecht'
        ],
        'transmission' => [
            VehicleTypeMotorTransmission::UNKNOWN => 'Onbekend',
            VehicleTypeMotorTransmission::MANUAL => 'Geschakeld',
            VehicleTypeMotorTransmission::SEMI_AUTOMATIC => 'Half-Automaat',
            VehicleTypeMotorTransmission::AUTOMATIC => 'Automaat'
        ]
    ]
];
