<?php
use DealerDirect\Generic\Category\Upholstery;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Category\VehicleTypeCarBodyType;
use DealerDirect\Generic\Category\VehicleTypeMotorBodyType;
use DealerDirect\Generic\Category\VehicleTypeCarCondition;
use DealerDirect\Generic\Category\VehicleTypeMotorCondition;
use DealerDirect\Generic\Category\VehicleTypeCarTransmission;
use DealerDirect\Generic\Category\VehicleTypeMotorTransmission;

return [
    'default' => 'Unbekannt',
    VehicleType::CAR => [
        'bodytype' => [
            VehicleTypeCarBodyType::UNKNOWN => 'Unbekannt',
            VehicleTypeCarBodyType::THREE_DOOR_HATCHBACK => '3-türige Kleinwagen',
            VehicleTypeCarBodyType::FOUR_DOOR_SALOON => '4-türige Limousine ',
            VehicleTypeCarBodyType::FIVE_DOOR_HATCHBACK => '5-türige Kleinwagen',
            VehicleTypeCarBodyType::MPV => 'VAN/Kleinbus',
            VehicleTypeCarBodyType::PASSENGER_BUS => 'Busse',
            VehicleTypeCarBodyType::SUV_CROSSOVER => 'SUV',
            VehicleTypeCarBodyType::STATION => 'Kombi',
            VehicleTypeCarBodyType::CONVERTIBLE => 'Cabrio',
            VehicleTypeCarBodyType::COUPE => 'Coupe',
            VehicleTypeCarBodyType::CROSS_COUNTRY => 'Geländewagen',
            VehicleTypeCarBodyType::VAN_SINGLE_CABIN => 'Transporter',
            VehicleTypeCarBodyType::VAN_DOUBLE_CABIN => 'Transporter Doppelkabine',
            VehicleTypeCarBodyType::TRUCK => 'LKW',
            VehicleTypeCarBodyType::PICKUP => 'Pick-up',
            VehicleTypeCarBodyType::CAMPER => 'Wohnmobil',
            VehicleTypeCarBodyType::CARAVAN => 'Wohnwagen',
            VehicleTypeCarBodyType::TRAILER => 'Anhänger',
            VehicleTypeCarBodyType::FOLDING_CARAVAN => 'Zeltanhänger',
            VehicleTypeCarBodyType::MICRO_CAR => 'Leichtkraftfahrzeug',
            // DEPRECATED:
            // VehicleTypeCarBodyType::CC_CONVERTIBLE_COUPE => 'CC: Cabrio & Coupe',
            // VehicleTypeCarBodyType::TWO_DOOR_HATCHBACK => '2-türige Kleinwagen',
            // VehicleTypeCarBodyType::TWO_DOOR_SALOON => '2-türige Limousine',
        ],
        'condition' => [
            VehicleTypeCarCondition::UNKNOWN => 'Unbekannt',
            VehicleTypeCarCondition::AS_NEW => 'Neuwertig',
            VehicleTypeCarCondition::GOOD => 'Gut',
            VehicleTypeCarCondition::AVERAGE => 'Normal',
            VehicleTypeCarCondition::BAD => 'Schlecht',
        ],
        'transmission' => [
            VehicleTypeCarTransmission::UNKNOWN => 'Unbekannt',
            VehicleTypeCarTransmission::MANUAL => 'Schaltgetriebe',
            VehicleTypeCarTransmission::AUTOMATIC => 'Automatik',
            VehicleTypeCarTransmission::SEMI_AUTOMATIC => 'Halbautomatik'
        ],
        'upholstery' => [
            Upholstery::UNKNOWN => 'Onbekend',
            Upholstery::ALCANTARA => 'Alcantara',
            Upholstery::CLOTH => 'Stof',
            Upholstery::SEMI_LEATHER => 'Half-leder',
            Upholstery::LEATHER => 'Leder',
            Upholstery::LEATHERETTE => 'Skai/Kunstleer'
        ]
    ],
    VehicleType::MOTOR => [
        'bodytype' => [
            VehicleTypeMotorBodyType::UNKNOWN => 'Unbekannt',
            VehicleTypeMotorBodyType::ALL_ROAD => 'All road',
            VehicleTypeMotorBodyType::CUSTOM => 'Chopper/Cruiser',
            VehicleTypeMotorBodyType::CROSS => 'Motocross',
            VehicleTypeMotorBodyType::ENDURO => 'Enduro',
            VehicleTypeMotorBodyType::NAKED => 'Naked Bike',
            VehicleTypeMotorBodyType::RACE => 'Rennsport',
            VehicleTypeMotorBodyType::SUPER_SPORT => 'Supersport',
            VehicleTypeMotorBodyType::SPORT_TOURING => 'Sport-tour',
            VehicleTypeMotorBodyType::MOTOR_SCOOTER => 'Motoroller',
            VehicleTypeMotorBodyType::SUPER_MOTO => 'Supermoto',
            VehicleTypeMotorBodyType::TOURING => 'Tour',
            VehicleTypeMotorBodyType::SIDE_CAR => 'Seitenwagen',
            VehicleTypeMotorBodyType::TRIKE => 'Trike',
            VehicleTypeMotorBodyType::CLASSIC => 'Klassisches',
            VehicleTypeMotorBodyType::QUAD => 'Quad',
            VehicleTypeMotorBodyType::MOPED_25 => 'Mofa 25',
            VehicleTypeMotorBodyType::MOPED_45 => 'Moped/Mokick 45',
            VehicleTypeMotorBodyType::TRIAL => 'Trial'
        ],
        'condition' => [
            VehicleTypeMotorCondition::UNKNOWN => 'Unbekannt',
            VehicleTypeMotorCondition::AS_NEW => 'Neuwertig',
            VehicleTypeMotorCondition::GOOD => 'Gut',
            VehicleTypeMotorCondition::AVERAGE => 'Normal',
            VehicleTypeMotorCondition::POOR => 'Schwach',
            VehicleTypeMotorCondition::BAD => 'Schlecht',
        ],
        'transmission' => [
            VehicleTypeMotorTransmission::UNKNOWN => 'Unbekannt',
            VehicleTypeMotorTransmission::MANUAL => 'Schaltgetriebe',
            VehicleTypeMotorTransmission::SEMI_AUTOMATIC => 'Halbautomatik',
            VehicleTypeMotorTransmission::AUTOMATIC => 'Automatik'
        ]
    ]
];
