<?php

namespace DealerDirect\Generic\Category;

/**
 * Class VehicleTypeCarCondition
 *
 * Car condition values
 *
 * Note that the values are *not* consistent with the values in VehicleTypeMotorCondition
 *
 * @package DealerDirect\Generic\Category
 */
class VehicleTypeCarCondition extends AbstractEnum
{
    // Condition not specified/unknown
    const UNKNOWN = 0;
    const NOT_SPECIFIED = 0;
    /**
     * Vehicle condition, "as good as *NEW*"
     */
    const AS_NEW = 4;
    const AS_NEW_CONDITION = 4;
    /**
     * Vehicle in *good* condition ("goed")
     */
    const GOOD = 1;
    const GOOD_CONDITION = 1;
    /**
     * Vehicle in *average* condition ("redelijk")
     */
    const AVERAGE = 2;
    const AVERAGE_CONDITION = 2;
    /**
     * Vehicle in *bad* condition ("slecht")
     */
    const BAD = 3;
    const BAD_CONDITION = 3;
}

