<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\Locale as LocaleCategory;
use DealerDirect\Generic\Category\Site;
use DealerDirect\Generic\Exception\NotImplementedException;

class LocaleRepository implements RepositoryInterface
{
    /**
     * Returns all possible locales for DealerDirect
     */
    public function getAll()
    {
        throw new NotImplementedException();
    }

    /**
     * Return default Locale for given site reference ID.
     *
     * @param int $siteReferenceId Site reference id
     * @param string $site Only used to specify French language, in case of Belgian site
     *
     * @return Locale The locale based on given site reference. Returns nl_NL as default locale.
     */
    public function getForSiteReference($siteReferenceId, $site = '')
    {
        switch ($siteReferenceId) {
            // German
            case Site::REF_CAR_DE:
            case Site::REF_MOTO_DE:
            case Site::REF_SCOOTER_DE:
                return new Locale('de', 'DE');
            // Belgian
            case Site::REF_CAR_BE_NL:
                return new Locale('nl', 'BE');
            case Site::REF_CAR_BE_FR:
                return new Locale('fr', 'BE');
            case Site::REF_MOTO_BE:
            case Site::REF_SCOOTER_BE:
                if (strpos($site, Site::SITE_LANGUAGE_CHECK_FRENCH) !== false) {
                    return new Locale('fr', 'BE');
                }
                return new Locale('nl', 'BE');
            case Site::REF_CAR_FR:
                return new Locale('fr', 'FR');
            // Dutch
            default:
                return new Locale('nl', 'NL');
        }
    }

    /**
     * Return default Locale (as string) for given site reference ID.
     *
     * @param int $siteReferenceId Site reference id
     * @param string $site Only used to specify French language, in case of Belgian site
     *
     * @return string The locale string based on given site reference. Returns nl_NL as default locale.
     */
    public function getForSiteReferenceAsString($siteReferenceId, $site = '')
    {
        switch ($siteReferenceId) {
            // German
            case Site::REF_CAR_DE:
            case Site::REF_MOTO_DE:
            case Site::REF_SCOOTER_DE:
                return LocaleCategory::DE_DE;
            // Belgian
            case Site::REF_CAR_BE_NL:
                return LocaleCategory::NL_BE;
            case Site::REF_CAR_BE_FR:
                return LocaleCategory::FR_BE;
            case Site::REF_MOTO_BE:
            case Site::REF_SCOOTER_BE:
                if (strpos($site, Site::SITE_LANGUAGE_CHECK_FRENCH) !== false) {
                    return LocaleCategory::FR_BE;
                }
                return LocaleCategory::NL_BE;
            case Site::REF_CAR_FR:
                return LocaleCategory::FR_FR;
            // Dutch
            default:
                return LocaleCategory::NL_NL;
        }
    }

}
