<?php

namespace DealerDirect\Generic\Repository;

use Dealerdirect\Generic\AbstractTestCase;
use DealerDirect\Generic\Category\Locale as LocaleCategory;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\DataProvider;

#[CoversClass(Locale::class)]
class LocaleTest extends AbstractTestCase
{
    /**
     * @param $language
     * @param $country
     * @param $expectedLocaleString
     */
    #[DataProvider('provideLanguageAndCountryCodes')]
    public function testCreatedLocaleShouldBeCorrectlyCastAsString($language, $country, $expectedLocaleString): void
    {
        $locale = new Locale($language, $country);
        $localeString = (string)$locale;
        self::assertEquals($expectedLocaleString, $localeString);
    }

    /**
     * @param $language
     * @param $country
     * @param $expectedLocale
     */
    #[DataProvider('provideLanguageAndCountryCodes')]
    public function testLocaleShouldBeCorrectlyCreatedFromString($language, $country, $expectedLocale): void
    {
        $localeString = $language . '_' . $country;
        $locale = Locale::fromString($localeString);

        self::assertEquals($expectedLocale, (string)$locale);
    }

    public function testCreateLocaleFromInvalidStringShouldThrowInvalidArgumentException(): void
    {
        $this->expectException('InvalidArgumentException');
        Locale::fromString('nl-Nl');
    }

    /**
     * @return array[] Returns 3 dim-arrays with values: {LanguageId, CountryId, ExpectedLocale}
     */
    public static function provideLanguageAndCountryCodes(): array
    {
        return [
            ['nl', 'NL', LocaleCategory::NL_NL],
            ['nl', 'BE', LocaleCategory::NL_BE],
            ['fr', 'BE', LocaleCategory::FR_BE],
            ['fr', 'FR', LocaleCategory::FR_FR],
            ['de', 'DE', LocaleCategory::DE_DE],
        ];
    }
}
