<?php

use DealerDirect\Generic\Category\CallStatus;
use DealerDirect\Generic\Category\Color;
use DealerDirect\Generic\Category\Country;
use DealerDirect\Generic\Category\DamageFree;
use DealerDirect\Generic\Category\DistanceUnit;
use DealerDirect\Generic\Category\Driveable;
use DealerDirect\Generic\Category\EnginePower;
use DealerDirect\Generic\Category\Fuel;
use DealerDirect\Generic\Category\LacquerTint;
use DealerDirect\Generic\Category\OldNewModel;
use DealerDirect\Generic\Category\PaintworkType;
use DealerDirect\Generic\Category\ServiceHistoryBooklet;
use DealerDirect\Generic\Category\ValueAddedTax;

return [
    'callstatus' => [
        CallStatus::BEING_PROCESSED => 'being processed',
        CallStatus::CALL_AGAIN => 'call again',
        CallStatus::CALL_BACK_AFTER_AUCTION => 'call back after auction',
        CallStatus::CALL_DIRECT => 'call direct',
        CallStatus::CALLED => 'called',
        CallStatus::LEFT_VOICE_MAIL_MESSAGE => 'left voicemail message',
        CallStatus::LOT_DISCUSSED_WITH_CONSUMER => 'lot discussed with consumer',
        CallStatus::NO_ANSWER => 'no answer',
        CallStatus::LEAVING_SERVICE => 'left service',
        CallStatus::REACTIVATED => 'reactivated',
        CallStatus::REQUEST_CONTACT_INFORMATION => 'request contact information',
        CallStatus::RESPECT_THE_CHANNEL => 'RTC',
        CallStatus::SOLD_BY_CONSUMER => 'sold by consumer',
        CallStatus::SOLD_UNDER_OTHER_LOT => 'sold under other lot',
        CallStatus::TURBO_AUCTION => 'turbo auction',
        CallStatus::FAKE => 'fake',
        CallStatus::DUPLICATE => 'duplicate vehicle',
        CallStatus::CALL_BACK_APPOINTMENT => 'call back appointment',
        CallStatus::PUT_THROUGH => 'put through'
    ],
    'color' => [
        Color::BEIGE => 'beige',
        Color::BLUE => 'blue',
        Color::GREEN => 'green',
        Color::BROWN => 'brown',
        Color::YELLOW => 'yellow',
        Color::GRAY => 'gray',
        Color::ORANGE => 'orange',
        Color::PURPLE => 'purple',
        Color::RED => 'red',
        Color::PINK => 'pink',
        Color::WHITE => 'white',
        Color::SILVER_GRAY => 'silver gray',
        Color::BLACK => 'black'
    ],
    'country' => [
        Country::NETHERLANDS => 'The Netherlands',
        Country::BELGIUM => 'Belgium',
        Country::GERMANY => 'Germany',
        Country::FRANCE => 'France',
        Country::SWEDEN => 'Sweden',
        Country::DENMARK => 'Denmark',
        Country::NORWAY => 'Norway',
        Country::POLAND => 'Poland',
        Country::AUSTRIA => 'Austria',
        Country::LUXEMBOURG => 'Luxembourg',
        Country::SWITZERLAND => 'Switzerland'
    ],
    'distanceunit' => [
        DistanceUnit::NOT_SPECIFIED => 'km',
        DistanceUnit::KM => 'km',
        DistanceUnit::MILES => 'miles',
    ],
    'damageFree' => [
        DamageFree::NO => 'No',
        DamageFree::YES => 'Yes',
        DamageFree::UNKNOWN => 'Unknown',
    ],
    'driveable' => [
        Driveable::UNKNOWN => 'Choose...',
        Driveable::NO => 'No',
        Driveable::YES => 'Yes',
    ],
    'enginepower' => [
        EnginePower::UNIT_KW => 'kW',
        EnginePower::UNIT_HP => 'HP'
    ],
    'fuel' => [
        Fuel::UNKNOWN => 'Unknown',
        Fuel::GASOLINE => 'Gasoline',
        Fuel::DIESEL => 'Diesel',
        Fuel::ELECTRICITY => 'Electric',
        Fuel::LPG => 'Autogas LPG',
        Fuel::LPG_G3 => 'LPG',
        Fuel::CRYOGENIC => 'Cryogenic',
        Fuel::CNG => 'CNG',
        Fuel::HYDROGEN => 'Hydrogen',
        Fuel::HYBRID_GASOLINE => 'Hybrid/Gasoline',
        Fuel::HYBRID_DIESEL => 'Hybrid/Diesel',
        Fuel::HYBRID_GASOLINE_LPG => 'Hybrid/Gasoline/LPG',
    ],
    'serviceHistoryBooklet' => [
        ServiceHistoryBooklet::UNKNOWN => 'Choose...',
        ServiceHistoryBooklet::NO => 'No',
        ServiceHistoryBooklet::YES => 'Yes',
    ],
    'paintworktype' => [
        PaintworkType::UNKNOWN => 'Unknown',
        PaintworkType::REGULAR => 'Regular varnish',
        PaintworkType::METALLIC => 'Metallic varnish',
        PaintworkType::PEARL => 'Pearl',
    ],
    'oldNewModel' => [
        OldNewModel::UNKNOWN => 'Choose...',
        OldNewModel::NEW => 'New',
        OldNewModel::OLD => 'Old',
    ],
    'lacquerTint' => [
        LacquerTint::UNKNOWN => 'Unknown',
        LacquerTint::LIGHT => 'Light',
        LacquerTint::MIDDLE => 'Middle',
        LacquerTint::DARK => 'Dark',
    ],
    'valueaddedtax' => [
        ValueAddedTax::UNKNOWN => 'Unknown',
        ValueAddedTax::UNKNOWN_3 => 'Unknown(3)',
        ValueAddedTax::DEDUCTIBLE => 'deductible',
        ValueAddedTax::NON_DEDUCTIBLE => 'Non-deductible'
    ]
];
