<?php

namespace Dealerdirect\Generic\Category;

class ResponseType extends AbstractEnum
{
    /* The NuSoap client is "special" as it only accepts `text/xml` as valid Content Type */
    const NU_SOAP = 'text/xml';
    const REST = 'application/json';
    const SOAP = 'application/soap+xml';
    const TEXT = 'text/plain';

    /*
     * To keep an overview of what is actually used across the code-base,
     * please only add media types if and when they are needed.
     *
     * The most commonly used types are:
     *
     *     application/javascript for JSONP
     *     application/x-www-form-urlencoded
     *     application/zip
     *     application/pdf
     *     application/sql
     *     application/msword (.doc)
     *     application/vnd.openxmlformats-officedocument.wordprocessingml.document(.docx)
     *     application/vnd.ms-excel (.xls)
     *     application/vnd.openxmlformats-officedocument.spreadsheetml.sheet (.xlsx)
     *     application/vnd.ms-powerpoint (.ppt)
     *     application/vnd.openxmlformats-officedocument.presentationml.presentation (.pptx)
     *     audio/mpeg
     *     audio/vorbis
     *     multipart/form-data
     *     text/css
     *     text/html
     *     text/csv
     *     text/plain
     *     image/png
     *     image/jpeg
     *     image/gif
     *
     * A full list can be found at:
     *     https://www.iana.org/assignments/media-types/media-types.xhtml
     */
}

/*EOF*/
