<?php

namespace DealerDirect\Generic\Util;

use DealerDirect\Generic\Category\Gender;
use DealerDirect\Generic\Category\Locale;

class Salutation
{
    /**
     * Provide a gender-specific salutation for languages that use them
     *
     * Returns an empty string if the locale does not use gender-specific
     * salutations.
     *
     * Gender must be numeric (as it is stored in the database). Possible values:
     * - 1: Male
     * - 2: Female
     * - 0: Unknown (no longer used; presumed male)
     *
     * @param string $locale
     * @param int $gender
     *
     * @return string
     *
     * @throws \InvalidArgumentException
     */
    public static function get($locale, $gender)
    {
        Locale::assertExists($locale);
        Gender::assertExists($gender);

        switch ($locale) {
            case Locale::DE_DE:
                $result = ($gender === Gender::FEMALE) ? 'Sehr geehrte Frau' : 'Sehr geehrter Herr';
                break;
            case Locale::FR_BE:
            case Locale::FR_FR:
                $result = ($gender === Gender::FEMALE) ? 'Chère madame' : 'Cher monsieur';
                break;
            default:
                $result = '';
                break;
        }

        return $result;
    }
}
