<?php

namespace DealerDirect\Generic\Repository;

/**
 * Tests for the Credentials class
 *
 * @coversDefaultClass DealerDirect\Generic\Repository\Credentials
 * @covers ::__construct
 * @covers ::<!public>
 */
class CredentialsTest extends \PHPUnit_Framework_TestCase
{
    const MOCK_NAME = 'mockName';
    const MOCK_PASSWORD = 'mockPassword';

    /**
     * @coversNothing
     */
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutUserName()
    {
        $this->expectException(\PHPUnit_Framework_Error::class);
        $this->expectExceptionMessage(
            'Missing argument 1 for DealerDirect\Generic\Repository\Credentials::__construct()'
        );
        /** @noinspection PhpParamsInspection */
        new Credentials();
    }

    /**
     * @coversNothing
     */
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutPassword()
    {
        $this->expectException(\PHPUnit_Framework_Error::class);
        $this->expectExceptionMessage(
            'Missing argument 2 for DealerDirect\Generic\Repository\Credentials::__construct()'
        );
        /** @noinspection PhpParamsInspection */
        new Credentials(self::MOCK_NAME);
    }

    /**
     * @covers ::getUsername
     */
    final public function testCredentialsWillReturnUsernameItHasBeenGivenWhenAskedForUsername()
    {
        $expected = self::MOCK_NAME;

        $credentials = new Credentials($expected, self::MOCK_PASSWORD);

        $actual = $credentials->getUsername();

        self::assertEquals($expected, $actual);
    }

    /**
     * @covers ::getPassword
     */
    final public function testCredentialsWillReturnPasswordItHasBeenGivenWhenAskedForPassword()
    {
        $expected = self::MOCK_PASSWORD;

        $credentials = new Credentials(self::MOCK_NAME, $expected);

        $actual = $credentials->getPassword();

        self::assertEquals($expected, $actual);
    }
}
