<?php

namespace DealerDirect\Generic\Category;

/**
 * This enum contains the available types of emails that can be sent from the email-service.
 *
 * Any constants added to this class MUST be constructed as follows:
 *
 *     {ACTOR}_{SUBJECT}
 *
 * Where {ACTOR} MUST be one of:
 *
 * - Consumer (Seller of a vehicle)
 * - Dealer (Buyer of vehicles)
 *
 * The value of {SUBJECT} depends on the topic of the email in question.
 *
 * Examples:
 *
 *     CONSUMER_CANNOT_REACH_DEALER
 *     DEALER_CANNOT_BE_REACHED
 *
 * Values defined before this comment was placed do not need to be amended.
 *
 */
final class EmailType extends AbstractEnum
{
    /*/ Consumer Emails /*/
    const CONFIRMATION_EMAIL = 'confirm-email';
    const CONSUMER_CANNOT_REACH_DEALER = 'consumer-cannot-reach-dealer';
    const CONSUMER_DATA_ERROR = 'consumer-data-error';
    const CONSUMER_DATA_SUCCESS = 'consumer-data-success';
    const CONSUMER_PURCHASE_CANCELLED_BY_DEALER = 'consumer-purchase-cancelled-by-dealer';
    const CONSUMER_SALE_CANCELLED_BY_CONSUMER = 'consumer-sale-cancelled-by-consumer';
    const CONSUMER_UNHAPPY_DEALER = 'consumer-unhappy-dealer';
    const EMAIL_CONFIRMED = 'email-confirmed';
    const HIGHEST_BID = 'highest-bid';
    const HIGHEST_BID_OFFENDING = 'highest-bid-offending';
    const LOT_ACTIVATED = 'lot-activated';
    const REQUEST_PHONE = 'request-phone';
    const REQUEST_PHOTO = 'request-photo';
    const REQUEST_PHOTO_REMINDER = 'request-photo-reminder';
    const SALE_AGREEMENT = 'sale-agreement';
    const TRAIN_TICKET_REFUND = 'train-ticket-refund';
    const TRUSTPILOT_INVITE = 'trustpilot';

    /*/ Dealer Emails /*/
    const DEALER_CANNOT_BE_REACHED = 'dealer-cannot-be-reached';
    const DEALER_COMPLIMENT_FROM_CONSUMER = 'dealer-compliment-from-consumer';
    const DEALER_OUTBID = 'outbid';
    const DEALER_REGISTRATION = 'dealer-registration';
    const DEALER_REQUEST_DELIVERY_CONFIRMATION = 'dealer-request-delivery-confirmation';
    const PURCHASE_AGREEMENT = 'purchase-agreement';
    const SEARCH_RESULT = 'search-result';
}

/*EOF*/
