<?php

namespace DealerDirect\Generic\Repository;

use Dealerdirect\Generic\AbstractTestCase;

/**
 * Tests for the Credentials class
 *
 * @coversDefaultClass DealerDirect\Generic\Repository\Credentials
 * @covers ::__construct
 * @covers ::<!public>
 */
class CredentialsTest extends AbstractTestCase
{
    const MOCK_NAME = 'mockName';
    const MOCK_PASSWORD = 'mockPassword';

    /**
     * @coversNothing
     */
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutUserName()
    {
        $exceptionName = $this->getCompatibleExceptionName('\\ArgumentCountError');

        $this->expectException($exceptionName);
        $this->expectExceptionMessageRegExp('/Missing argument 1|0 passed/');

        /** @noinspection PhpParamsInspection */
        new Credentials();
    }

    /**
     * @coversNothing
     */
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutPassword()
    {
        $exceptionName = $this->getCompatibleExceptionName('\\ArgumentCountError');

        $this->expectException($exceptionName);
        $this->expectExceptionMessageRegExp('/Missing argument 2|1 passed/');

        /** @noinspection PhpParamsInspection */
        new Credentials(self::MOCK_NAME);
    }

    /**
     * @covers ::getUsername
     */
    final public function testCredentialsWillReturnUsernameItHasBeenGivenWhenAskedForUsername()
    {
        $expected = self::MOCK_NAME;

        $credentials = new Credentials($expected, self::MOCK_PASSWORD);

        $actual = $credentials->getUsername();

        self::assertEquals($expected, $actual);
    }

    /**
     * @covers ::getPassword
     */
    final public function testCredentialsWillReturnPasswordItHasBeenGivenWhenAskedForPassword()
    {
        $expected = self::MOCK_PASSWORD;

        $credentials = new Credentials(self::MOCK_NAME, $expected);

        $actual = $credentials->getPassword();

        self::assertEquals($expected, $actual);
    }
}
