<?php

namespace DealerDirect\Generic\Config;

class DummyConfigTest extends AbstractConfigTest
{
    const MOCK_VALUE = 'mock-value';
    const MOCK_KEY = 'mock-key';
    const MOCK_MULTIBYTE_KEY = '💥';

    public function getSubject()
    {
        // TODO: Implement getSubject() method.
    }

    private $mockConfigArray = [
        self::MOCK_KEY => self::MOCK_VALUE,
        self::MOCK_MULTIBYTE_KEY => self::MOCK_MULTIBYTE_KEY,
    ];

    public function testConfigShouldComplainWhenInstantiatedWithoutConfigArray()
    {
        $this->markTestIncomplete('@TODO:B.Peachey, fix this!');
        $exceptionName = \PHPUnit_Framework_Error::class;

        if (class_exists('\TypeError') && $this->namespaceExists('Symfony\\Polyfill') === false) {
            $exceptionName = \TypeError::class;
        }

        $this->expectException($exceptionName);
        $this->expectExceptionMessageRegExp('/none given|0 passed/');

        new DummyConfig();
    }

    /**
     * @param mixed $invalidConfig
     *
     * @dataProvider provideNonArrayValues
     */
    public function testConfigShouldComplainWhenInstantiatedWithConfigThatIsNotArray($invalidConfig)
    {
        $this->markTestIncomplete('@TODO:B.Peachey, fix this!');
        $message = 'must be of the type array';

        $exceptionName = \PHPUnit_Framework_Error::class;

        if (class_exists('\TypeError') && $this->namespaceExists('Symfony\\Polyfill') === false) {
            $exceptionName = \TypeError::class;
        }

        $this->expectException($exceptionName);
        $this->expectExceptionMessage($message);

        new DummyConfig($invalidConfig);
    }

    public function testConfigShouldComplainWhenValueRetrievedBeforeItIsSet()
    {
        $dummyConfig = new DummyConfig([]);

        $this->expectException(ConfigException::class);

        $dummyConfig->get(self::MOCK_KEY);
    }

    public function testConfigShouldOnlyStoreValuesForKeysItIsFamiliarWithWhenGivenValues()
    {
        $mockConfigArray = [
            self::MOCK_KEY => self::MOCK_VALUE,
            /* Adding a key that DummyConfig is not familiar with */
            'unfamiliar-key' => 'unfamiliar-value',
        ];

        $dummyConfig = new DummyConfig($mockConfigArray);

        $exist = $dummyConfig->exist('unfamiliar-key');

        $this->assertFalse($exist, 'key provided is not expected to exist');
    }

    public function testConfigShouldThrowExceptionWhenAskedToAssertExistenceOfNonExistingKey()
    {
        $dummyConfig = new DummyConfig($this->mockConfigArray);

        $this->expectException(ConfigException::class);

        $dummyConfig->assertExist('non-existing-key');

    }

    public function testConfigShouldReturnValueRelatedToGivenKeyWhenAskedForValueRelatedToGivenKey()
    {
        $dummyConfig = new DummyConfig($this->mockConfigArray);

        $expected = self::MOCK_VALUE;
        $actual = $dummyConfig->get(self::MOCK_KEY);

        self::assertEquals($expected, $actual);
    }

    public function testConfigShouldReturnFalseWhenAskedExistenceOfNonExistingKey()
    {
        $dummyConfig = new DummyConfig($this->mockConfigArray);

        $exists = $dummyConfig->exist('non-existing-key');


        $this->assertFalse($exists);
    }

    public function testConfigShouldAcceptKeyWhenGivenKeyIsMultiByteString()
    {
        $config = new DummyConfig($this->mockConfigArray);

        $expected = self::MOCK_MULTIBYTE_KEY;
        $actual = $config->get(self::MOCK_MULTIBYTE_KEY);

        self::assertEquals($expected,$actual);
    }

    public function testConfigShouldContainKeysWhenKeysAreDefined()
    {
        $mockConfigArray = $this->mockConfigArray;

        $config = new DummyConfig($mockConfigArray);

        $expected = array_keys($mockConfigArray);
        $actual = $config->getKeys();

        self::assertEquals($expected,$actual);
    }

    public function testConfigShouldOnlyExceptStringForKeysWhenKeysAreDefined()
    {
        $this->markTestSkipped('No clue how to test this'); // The `getKeys` definition in DummyConfig should contain "true" to test this
    }

    public function testConfigShouldCheckIfObjectIsActuallySupported()
    {

        $unsupported = [
            'unsupported-key' => 'unsupported-value',
        ];

        $dummyConfig = new DummyConfig($unsupported);

        $this->expectException(ConfigException::class);
        $this->expectExceptionMessage('is not-supported');

        $dummyConfig->get('unsupported-key');

    }

    public function provideNonArrayValues()
    {
        return [
            'true' => [true],
            'false' => [false],
            'null' => [null],
            'integer' => [1],
            'float' => [1.2345],
            'resource' => [fopen(__FILE__, 'r')],
            'object' => [new \stdClass()],
        ];
    }
}
