<?php

namespace DealerDirect\Generic\Util;

use Dealerdirect\Generic\AbstractTestCase;
use DealerDirect\Generic\Category\Locale;
use DealerDirect\Generic\Category\Gender;

/**
 * @coversDefaultClass DealerDirect\Generic\Util\Salutation
 * @covers ::get
 */
class SalutationTest extends AbstractTestCase
{
    const INVALID_LOCALE = 'foo';
    const INVALID_GENDER = 42;

    public function testGetThrowsExceptionWhenGivenInvalidLocale()
    {
        $this->expectException('\InvalidArgumentException');
        $this->expectExceptionMessage('is not a valid');

        Salutation::get(self::INVALID_LOCALE, Gender::FEMALE);
    }

    public function testGetThrowsExceptionWhenGivenInvalidGender()
    {
        $this->expectException('\InvalidArgumentException');
        $this->expectExceptionMessage('is not a valid');

        Salutation::get(Locale::NL_NL, self::INVALID_GENDER);
    }

    public function testGetForDeDeReturnsGenderSpecificValues()
    {
        $maleSalutation = Salutation::get(Locale::DE_DE, Gender::MALE);
        $femaleSalutation = Salutation::get(Locale::DE_DE, Gender::FEMALE);

        self::assertNotSame($maleSalutation, $femaleSalutation);
    }

    public function testGetForFrBeReturnsGenderSpecificValues()
    {
        $maleSalutation = Salutation::get(Locale::FR_BE, Gender::MALE);
        $femaleSalutation = Salutation::get(Locale::FR_BE, Gender::FEMALE);

        self::assertNotSame($maleSalutation, $femaleSalutation);
    }

    public function testGetForNlNlReturnsGenderSpecificValues()
    {
        $maleSalutation = Salutation::get(Locale::NL_NL, Gender::MALE);
        $femaleSalutation = Salutation::get(Locale::NL_NL, Gender::FEMALE);

        self::assertSame($maleSalutation, $femaleSalutation);
        self::assertSame('', $maleSalutation, 'Salutation should be empty string or gender specific');
    }
}
