<?php
use DealerDirect\Generic\Category\Upholstery;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Category\VehicleTypeCarBodyType;
use DealerDirect\Generic\Category\VehicleTypeMotorBodyType;
use DealerDirect\Generic\Category\VehicleTypeCarCondition;
use DealerDirect\Generic\Category\VehicleTypeMotorCondition;
use DealerDirect\Generic\Category\VehicleTypeCarTransmission;
use DealerDirect\Generic\Category\VehicleTypeMotorTransmission;

return [
    'default' => 'Onbekend',
    VehicleType::CAR => [
        'bodytype' => [
            VehicleTypeCarBodyType::UNKNOWN => 'Unknown',
            VehicleTypeCarBodyType::THREE_DOOR_HATCHBACK => '3-door Hatchback',
            VehicleTypeCarBodyType::FOUR_DOOR_SALOON => '4-door Saloon',
            VehicleTypeCarBodyType::FIVE_DOOR_HATCHBACK => '5-door Hatchback',
            VehicleTypeCarBodyType::MPV => 'MPV',
            VehicleTypeCarBodyType::SUV_CROSSOVER => 'SUV',
            VehicleTypeCarBodyType::STATION => 'Stationwagon',
            VehicleTypeCarBodyType::CONVERTIBLE => 'Convertible',
            VehicleTypeCarBodyType::COUPE => 'Coupe',
            VehicleTypeCarBodyType::CC_CONVERTIBLE_COUPE => 'CC: Convertible & Coupe',
            VehicleTypeCarBodyType::CROSS_COUNTRY => 'Cross-country vehicle',
            VehicleTypeCarBodyType::VAN_SINGLE_CABIN => 'Van single cabin',
            VehicleTypeCarBodyType::VAN_DOUBLE_CABIN => 'Van double cabin',
            VehicleTypeCarBodyType::CAMPER => 'Camper',
            VehicleTypeCarBodyType::CARAVAN => 'Caravan',
            VehicleTypeCarBodyType::TRAILER => 'Trailer',
            VehicleTypeCarBodyType::FOLDING_CARAVAN => 'Folding caravan',
            VehicleTypeCarBodyType::MICRO_CAR => 'Microcar',
            VehicleTypeCarBodyType::TWO_DOOR_HATCHBACK => '2-door Hatchback',
            VehicleTypeCarBodyType::TWO_DOOR_SALOON => '2-door Saloon',
            VehicleTypeCarBodyType::PASSENGER_BUS => 'Passenger bus'
        ],
        'condition' => [
            VehicleTypeCarCondition::UNKNOWN => 'Unknown',
            VehicleTypeCarCondition::AS_NEW => 'As new',
            VehicleTypeCarCondition::GOOD => 'Good',
            VehicleTypeCarCondition::AVERAGE => 'Average',
            VehicleTypeCarCondition::BAD => 'Bad'
        ],
        'transmission' => [
            VehicleTypeCarTransmission::UNKNOWN => 'Unknown',
            VehicleTypeCarTransmission::MANUAL => 'Manual',
            VehicleTypeCarTransmission::AUTOMATIC => 'Automatic',
            VehicleTypeCarTransmission::SEMI_AUTOMATIC => 'Semi-automatic'
        ],
        'upholstery' => [
            Upholstery::UNKNOWN => 'Unknown',
            Upholstery::ALCANTARA => 'Alcantara',
            Upholstery::CLOTH => 'Cloth',
            Upholstery::SEMI_LEATHER => 'Half-leather',
            Upholstery::LEATHER => 'Leather',
            Upholstery::LEATHERETTE => 'Leatherette'
        ]
    ],
    VehicleType::MOTOR => [
        'bodytype' => [
            VehicleTypeMotorBodyType::UNKNOWN => 'Unknown',
            VehicleTypeMotorBodyType::ALL_ROAD => 'All road',
            VehicleTypeMotorBodyType::CUSTOM => 'Custom',
            VehicleTypeMotorBodyType::CROSS => 'Motocross',
            VehicleTypeMotorBodyType::ENDURO => 'Enduro',
            VehicleTypeMotorBodyType::NAKED => 'Naked bike',
            VehicleTypeMotorBodyType::RACE => 'Race',
            VehicleTypeMotorBodyType::SUPER_SPORT => 'Supersport',
            VehicleTypeMotorBodyType::SPORT_TOURING => 'Sport-tour',
            VehicleTypeMotorBodyType::MOTOR_SCOOTER => 'Motor Scooter',
            VehicleTypeMotorBodyType::SUPER_MOTO => 'Supermoto',
            VehicleTypeMotorBodyType::TOURING => 'Tour',
            VehicleTypeMotorBodyType::SIDE_CAR => 'Side-car',
            VehicleTypeMotorBodyType::TRIKE => 'Trike',
            VehicleTypeMotorBodyType::CLASSIC => 'Classic',
            VehicleTypeMotorBodyType::QUAD => 'Quad',
            VehicleTypeMotorBodyType::MOPED_25 => 'Moped 25',
            VehicleTypeMotorBodyType::MOPED_45 => 'Moped 45',
            VehicleTypeMotorBodyType::TRIAL => 'Trial'
        ],
        'condition' => [
            VehicleTypeMotorCondition::UNKNOWN => 'Unknown',
            VehicleTypeMotorCondition::AS_NEW => 'As new',
            VehicleTypeMotorCondition::GOOD => 'Good',
            VehicleTypeMotorCondition::AVERAGE => 'Average',
            VehicleTypeMotorCondition::POOR => 'Poor',
            VehicleTypeMotorCondition::BAD => 'Bad'
        ],
        'transmission' => [
            VehicleTypeMotorTransmission::UNKNOWN => 'Unknown',
            VehicleTypeMotorTransmission::MANUAL => 'Manual',
            VehicleTypeMotorTransmission::SEMI_AUTOMATIC => 'Semi-automatic',
            VehicleTypeMotorTransmission::AUTOMATIC => 'Automatic'
        ]
    ]
];
