<?php

namespace Dealerdirect\Generic;

use PHPUnit\Framework\TestCase;
use Potherca\PhpUnit;

abstract class AbstractTestCase extends TestCase
{
    use PhpUnit\CreateDataProviderTrait;
    use PhpUnit\CreateObjectFromAbstractClassTrait;
    use PhpUnit\GetCompatibleExceptionNameTrait;
    use PhpUnit\SetNonPublicPropertyTrait;

    /**
     * @param $categoryClass Catogory Enum class to load key value pairs from
     * @param $keyPrefix
     *
     * @return array Dataprovider result array
     */
    protected function getCategoriesAsDataProvider($categoryClass, $keyPrefix)
    {
        $catKeys = $categoryClass::getAll();

        $data = [];
        array_walk($catKeys, function ($value) use (&$data, $categoryClass, $keyPrefix) {
            $key = $categoryClass::getKey($value);
            $data['('. $keyPrefix . $key .')'] = [$value];
        });

        ksort($data);

        return $data;
    }
}

/*EOF*/
