<?php

namespace DealerDirect\Generic;

use DealerDirect\Generic\DataType\Country;
use DealerDirect\Generic\DataType\Locale;
use DealerDirect\Generic\DataType\VehicleType;

/**
 * Immutable class to hold values of generic properties
 */
final class GenericProperties
{
    /** @var string */
    private $country;
    /** @var string */
    private $locale;
    /** @var string */
    private $vehicleType;

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @return string
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }

    /**
     * Instantiate a GenericProperties object based on DataType values
     *
     * @param string $country
     * @param string $vehicleType
     * @param string $locale
     *
     * @throws \InvalidArgumentException
     */
    final public function __construct($country, $vehicleType, $locale = '')
    {
        Country::assertExists($country);
        VehicleType::assertExists($vehicleType);

        $this->country = (string) $country;
        $this->vehicleType = (string) $vehicleType;

        $locale = (string) $locale;
        if ($locale !== '') {
            Locale::assertExists($locale);
            $this->locale = $locale;
        }
    }
}