<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Repository\CallGroupInformation;
use Doctrine\DBAL\Connection;
use PHPUnit\Framework\TestCase;

/**
 * @covers DealerDirect\Generic\Repository\CallGroupInformation
 */
class CallGroupInformationTest extends TestCase
{
    /**
     * @dataProvider provideValidCallGroupsWithExpectedResult
     */
    public function testGetCurrentCallGroupIdShouldReturnTheClassifiedCallGroupId(
        string $vehicleType,
        int $expected,
        array|int $fetchResult
    ) {
        $connection = $this->createStub(Connection::class);
        $connection->method('fetchAssociative')->willReturn($fetchResult);
        $connection->method('fetchOne')->willReturn($fetchResult);

        $callGroupInformation = new CallGroupInformation($connection, $vehicleType);

        $actual = $callGroupInformation->getCallGroupId(123456);

        $this->assertSame($expected, $actual);
    }

    public static function provideValidCallGroupsWithExpectedResult()
    {
        return [
            [VehicleType::MOTOR, 1, ['classification_id' => 1, 'reference' => 4, 'callgroup_id' => 81]],
            [VehicleType::SCOOTER, 84, ['classification_id' => null, 'reference' => 5, 'callgroup_id' => 84]],
            [VehicleType::CAR, 6, 6],
            [VehicleType::RECREATION, 51, 51],
        ];
    }
}
