<?php

namespace DealerDirect\Generic\Category;

/**
 * Class Site
 *
 * Containing all known DealerDirect Site Reference ID's
 *
 * @package DealerDirect\Generic\Category
 */
final class Site extends AbstractEnum
{
    /**
     * Reference unknown/unspecified
     */
    const REF_UNKNOWN = 0;
    /**
     * ikwilvanmijnautoaf.nl
     */
    const REF_CAR_NL = 1;
    /**
     * ikwilvanmijnautoaf.be
     */
    const REF_CAR_BE_NL = 2;
    /**
     * jevoudraisvendremavoiture.be
     */
    const REF_CAR_BE_FR = 200;
    /**
     * DealerDirect GMBH Reference ID
     */
    const REF_CAR_DE = 3;
    /**
     * DealerDirect FR Reference ID (Not in use)
     */
    const REF_CAR_FR = 4;
    /**
     * ikwilvanmijnmotorfietsaf.nl
     */
    const REF_MOTO_NL = 4;
    /**
     * ikwilvanmijnscooteraf.nl
     */
    const REF_SCOOTER_NL = 5;
    /**
     * ikwilvanmijnmotoraf.be
     */
    const REF_MOTO_BE = 40;
    /**
     * ikwilvanmijnscooteraf.be
     */
    const REF_SCOOTER_BE = 50; // >> FR
    /**
     * ichwillmeinmotorradloswerden.de
     */
    const REF_MOTO_DE = 400;
    const REF_SCOOTER_DE = 500;
    /**
     * For now, these are needed for Moto Sites,
     * to verify from which language site a customer came, because it's not verifiable by reference id
     */
    const SITE_LANGUAGE_CHECK_FRENCH = 'jevoudrais'; // "jevoudrais" specifies customer is coming via French site
    const SITE_LANGUAGE_CHECK_GERMAN = 'ichwill'; // "ichwill" specifies customer is coming via German site
    const SITE_LANGUAGE_CHECK_DUTCH = 'ikwilvan'; // "ikwilvan" specifies customer is coming via Dutch site
}

/*EOF*/
