<?php

namespace DealerDirect\Generic\Category;

/**
 * This enum contains the available types of emails that can be sent from the email-service.
 *
 * Any constants added to this class MUST be constructed as follows:
 *
 *     {ACTOR}_{SUBJECT}
 *
 * Where {ACTOR} MUST be one of:
 *
 * - Consumer (Seller of a vehicle)
 * - Dealer (Buyer of vehicles)
 *
 * The value of {SUBJECT} depends on the topic of the email in question.
 *
 * Examples:
 *
 *     CONSUMER_CANNOT_REACH_DEALER
 *     DEALER_CANNOT_BE_REACHED
 *
 * Values defined before this comment was placed do not need to be amended.
 *
 */
final class EmailType extends AbstractEnum
{
    /*/ Consumer Emails /*/
    const BID_TO_CONSUMER = 'send-bid-to-consumer';
    const CONFIRMATION_EMAIL = 'confirm-email';
    const CONSUMER_CANNOT_REACH_DEALER = 'consumer-cannot-reach-dealer';
    const CONSUMER_DATA_ERROR = 'consumer-data-error';
    const CONSUMER_DATA_SUCCESS = 'consumer-data-success';
    const CONSUMER_PURCHASE_CANCELLED_BY_DEALER = 'consumer-purchase-cancelled-by-dealer';
    const CONSUMER_SALE_CANCELLED_BY_CONSUMER = 'consumer-sale-cancelled-by-consumer';
    const CONSUMER_SELF_SOLD = 'consumer-self-sold';
    const CONSUMER_UNHAPPY_DEALER = 'consumer-unhappy-dealer';
    const EMAIL_CONFIRMED = 'email-confirmed';
    const HIGHEST_BID = 'highest-bid';
    const HIGHEST_BID_OFFENDING = 'highest-bid-offending';
    const LOT_ACTIVATED = 'lot-activated';
    const REQUEST_PHONE = 'request-phone';
    const REQUEST_PHOTO = 'request-photo';
    const REQUEST_PHOTO_REMINDER = 'request-photo-reminder';
    const SALE_AGREEMENT = 'sale-agreement';
    const TRAIN_TICKET_REFUND = 'train-ticket-refund';
    const TRUSTPILOT_INVITE = 'trustpilot';
    const DELIVERY_HANDLING_MANUAL = 'delivery-handling-manual';
    const DELIVERY_HANDLING_FIRST = 'delivery-handling-first';
    const DELIVERY_HANDLING_SECOND = 'delivery-handling-second';

    /*/ Consumer Inspection Service Emails /*/
    const CONSUMER_INSPECTION_INVITATION = 'consumer-inspection-invitation';
    const CONSUMER_INSPECTION_INVITATION_REMINDER = 'consumer-inspection-invitation-reminder';
    const CONSUMER_INSPECTION_PAYMENT_SUCCESSFUL = 'consumer-inspection-payment-successful';
    const CONSUMER_INSPECTION_PAYMENT_FAILED = 'consumer-inspection-payment-failed';
    const CONSUMER_INSPECTION_CONFIRMATION_OF_SERVICES = 'consumer-inspection-confirmation-of-services';
    const CONSUMER_INSPECTION_CONTRACTOR_CONFIRMATION = 'consumer-inspection-contractor-confirmation';
    const CONSUMER_INSPECTION_HIGHEST_BID_OFFENDING = 'consumer-inspection-highest-bid-offending';

    /*/ Dealer Emails /*/
    const DEALER_CANNOT_BE_REACHED = 'dealer-cannot-be-reached';
    const DEALER_COMPLIMENT_FROM_CONSUMER = 'dealer-compliment-from-consumer';
    const DEALER_OUTBID = 'outbid';
    const DEALER_REGISTRATION = 'dealer-registration';
    const DEALER_REQUEST_DELIVERY_CONFIRMATION = 'dealer-request-delivery-confirmation';
    const PURCHASE_AGREEMENT = 'purchase-agreement';
    const SEARCH_RESULT = 'search-result';
    const SUGGEST_LOT = 'suggest-lot';

    /*/ Lead nurturing /*/
    const LEAD_NURTURE_CURIOUS = 'lead-nurture-curious';
    const LEAD_NURTURE_VALUATION = 'lead-nurture-valuation';
    const LEAD_NURTURE_MORE_TIME = 'lead-nurture-more-time';
    const LEAD_NURTURE_ASKING_PRICE = 'lead-nurture-asking-price';
}
