<?php

namespace DealerDirect\Generic\Config;

/**
 * Interface to be implemented by classes that offer configuration logic.
 */
interface ConfigInterface
{
    const ERROR_GET_BEFORE_SET = 'Can not get value "%s" before it has been set';
    const ERROR_UNKNOWN_KEY = 'Configuration value for the requested key "%s" does not exist. Available keys are: "%s"';

    /**
     * Array of keys that the Config object can contain
     *
     * @return string[]
     */
    public function getKeys();

    /**
     * Validate if a given key exists and throws an exception if it does not exist
     *
     * To validate if a given key exists without throwing an exception, use the `exist` method
     *
     * @param string $key
     *
     * @return void
     *
     * @throws ConfigException Given key does not exist
     */
    public function assertExist($key);

    /**
     * Validate whether a given key exists or not
     *
     * @param string $key
     *
     * @return bool
     */
    public function exist($key);

    /**
     * Gets the value for a given key or throws an exception if it does not exist
     *
     * @param string $key
     *
     * @return mixed Value for given key
     *
     * @throws ConfigException Given key is not set
     */
    public function get($key);
}
