<?php

use PHPUnit\Framework\TestCase;
use DealerDirect\Generic\Category\VehicleTypeCarOptions;
use DealerDirect\Generic\Category\VehicleTypeMotorOptions;
use DealerDirect\Generic\Category\VehicleTypeRecreationalOptions;
use DealerDirect\Generic\Repository\Locale;
use DealerDirect\Generic\Category\Language;
use DealerDirect\Generic\Category\Territory;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Repository\GenericProperties;
use DealerDirect\Generic\Repository\Translator;
use DealerDirect\Generic\Category\TranslationTypes;

/**
 * Class VehicleTypeOptionsTest
 */
class VehicleTypeOptionsTest extends TestCase
{
    public function testUniqueVehicleTypeCarIds()
    {
        $carReflection = new ReflectionClass(new VehicleTypeCarOptions());
        foreach (array_count_values($carReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }
    
    public function testUniqueVehicleTypeMotorIds()
    {
        $motorReflection = new ReflectionClass(new VehicleTypeMotorOptions());
        foreach (array_count_values($motorReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    public function testUniqueVehicleTypeRecreationalIds()
    {
        $recreationalReflection = new ReflectionClass(new VehicleTypeRecreationalOptions());
        foreach (array_count_values($recreationalReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    public function testGermanAircoTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            VehicleTypeCarOptions::AIRCO,
        ]);
        $this->assertEquals($translatedValues[0], "Klimaanlage");
    }

    public function testWrongTranslationTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            'wrong_value',
        ]);
        $this->assertEquals($translatedValues[0], "Unbekannt");
    }
}
