<?php

namespace DealerDirect\Generic\Category;

/**
 * ISO_639-1 language codes
 */
final class Language extends AbstractEnum
{
    const ALPHA2 = 'alpha2'; // English
    const AA = 'aa'; // Afar
    const AB = 'ab'; // Abkhazian
    const AE = 'ae'; // Avestan
    const AF = 'af'; // Afrikaans
    const AK = 'ak'; // Akan
    const AM = 'am'; // Amharic
    const AN = 'an'; // Aragonese
    const AR = 'ar'; // Arabic
    const AS_ = 'as'; // Assamese
    const AV = 'av'; // Avaric
    const AY = 'ay'; // Aymara
    const AZ = 'az'; // Azerbaijani
    const BA = 'ba'; // Bashkir
    const BE = 'be'; // Belarusian
    const BG = 'bg'; // Bulgarian
    const BH = 'bh'; // Bihari languages
    const BI = 'bi'; // Bislama
    const BM = 'bm'; // Bambara
    const BN = 'bn'; // Bengali
    const BO = 'bo'; // Tibetan
    const BR = 'br'; // Breton
    const BS = 'bs'; // Bosnian
    const CA = 'ca'; // Catalan; Valencian
    const CE = 'ce'; // Chechen
    const CH = 'ch'; // Chamorro
    const CO = 'co'; // Corsican
    const CR = 'cr'; // Cree
    const CS = 'cs'; // Czech
    const CU = 'cu'; // Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic
    const CV = 'cv'; // Chuvash
    const CY = 'cy'; // Welsh
    const DA = 'da'; // Danish
    const DE = 'de'; // German
    const DV = 'dv'; // Divehi; Dhivehi; Maldivian
    const DZ = 'dz'; // Dzongkha
    const EE = 'ee'; // Ewe
    const EL = 'el'; // "Greek Modern (1453-)"
    const EN = 'en'; // English
    const EO = 'eo'; // Esperanto
    const ES = 'es'; // Spanish; Castilian
    const ET = 'et'; // Estonian
    const EU = 'eu'; // Basque
    const FA = 'fa'; // Persian
    const FF = 'ff'; // Fulah
    const FI = 'fi'; // Finnish
    const FJ = 'fj'; // Fijian
    const FO = 'fo'; // Faroese
    const FR = 'fr'; // French
    const FY = 'fy'; // Western Frisian
    const GA = 'ga'; // Irish
    const GD = 'gd'; // Gaelic; Scottish Gaelic
    const GL = 'gl'; // Galician
    const GN = 'gn'; // Guarani
    const GU = 'gu'; // Gujarati
    const GV = 'gv'; // Manx
    const HA = 'ha'; // Hausa
    const HE = 'he'; // Hebrew
    const HI = 'hi'; // Hindi
    const HO = 'ho'; // Hiri Motu
    const HR = 'hr'; // Croatian
    const HT = 'ht'; // Haitian; Haitian Creole
    const HU = 'hu'; // Hungarian
    const HY = 'hy'; // Armenian
    const HZ = 'hz'; // Herero
    const IA = 'ia'; // Interlingua (International Auxiliary Language Association)
    const ID = 'id'; // Indonesian
    const IE = 'ie'; // Interlingue; Occidental
    const IG = 'ig'; // Igbo
    const II = 'ii'; // Sichuan Yi; Nuosu
    const IK = 'ik'; // Inupiaq
    const IO = 'io'; // Ido
    const IS = 'is'; // Icelandic
    const IT = 'it'; // Italian
    const IU = 'iu'; // Inuktitut
    const JA = 'ja'; // Japanese
    const JV = 'jv'; // Javanese
    const KA = 'ka'; // Georgian
    const KG = 'kg'; // Kongo
    const KI = 'ki'; // Kikuyu; Gikuyu
    const KJ = 'kj'; // Kuanyama; Kwanyama
    const KK = 'kk'; // Kazakh
    const KL = 'kl'; // Kalaallisut; Greenlandic
    const KM = 'km'; // Central Khmer
    const KN = 'kn'; // Kannada
    const KO = 'ko'; // Korean
    const KR = 'kr'; // Kanuri
    const KS = 'ks'; // Kashmiri
    const KU = 'ku'; // Kurdish
    const KV = 'kv'; // Komi
    const KW = 'kw'; // Cornish
    const KY = 'ky'; // Kirghiz; Kyrgyz
    const LA = 'la'; // Latin
    const LB = 'lb'; // Luxembourgish; Letzeburgesch
    const LG = 'lg'; // Ganda
    const LI = 'li'; // Limburgan; Limburger; Limburgish
    const LN = 'ln'; // Lingala
    const LO = 'lo'; // Lao
    const LT = 'lt'; // Lithuanian
    const LU = 'lu'; // Luba-Katanga
    const LV = 'lv'; // Latvian
    const MG = 'mg'; // Malagasy
    const MH = 'mh'; // Marshallese
    const MI = 'mi'; // Maori
    const MK = 'mk'; // Macedonian
    const ML = 'ml'; // Malayalam
    const MN = 'mn'; // Mongolian
    const MR = 'mr'; // Marathi
    const MS = 'ms'; // Malay
    const MT = 'mt'; // Maltese
    const MY = 'my'; // Burmese
    const NA = 'na'; // Nauru
    const NB = 'nb'; // "Bokmålconst ND = 'nd'; // "Ndebeleconst NE = 'ne'; // Nepali
    const NG = 'ng'; // Ndonga
    const NL = 'nl'; // Dutch; Flemish
    const NN = 'nn'; // "Norwegian Nynorsk; Nynorskconst NO = 'no'; // Norwegian
    const NR = 'nr'; // "Ndebele South; South Ndebele"
    const NV = 'nv'; // Navajo; Navaho
    const NY = 'ny'; // Chichewa; Chewa; Nyanja
    const OC = 'oc'; // Occitan (post 1500); Provençal
    const OJ = 'oj'; // Ojibwa
    const OM = 'om'; // Oromo
    const OR_ = 'or'; // Oriya
    const OS = 'os'; // Ossetian; Ossetic
    const PA = 'pa'; // Panjabi; Punjabi
    const PI = 'pi'; // Pali
    const PL = 'pl'; // Polish
    const PS = 'ps'; // Pushto; Pashto
    const PT = 'pt'; // Portuguese
    const QU = 'qu'; // Quechua
    const RM = 'rm'; // Romansh
    const RN = 'rn'; // Rundi
    const RO = 'ro'; // Romanian; Moldavian; Moldovan
    const RU = 'ru'; // Russian
    const RW = 'rw'; // Kinyarwanda
    const SA = 'sa'; // Sanskrit
    const SC = 'sc'; // Sardinian
    const SD = 'sd'; // Sindhi
    const SE = 'se'; // Northern Sami
    const SG = 'sg'; // Sango
    const SI = 'si'; // Sinhala; Sinhalese
    const SK = 'sk'; // Slovak
    const SL = 'sl'; // Slovenian
    const SM = 'sm'; // Samoan
    const SN = 'sn'; // Shona
    const SO = 'so'; // Somali
    const SQ = 'sq'; // Albanian
    const SR = 'sr'; // Serbian
    const SS = 'ss'; // Swati
    const ST = 'st'; // "Sotho Southern"
    const SU = 'su'; // Sundanese
    const SV = 'sv'; // Swedish
    const SW = 'sw'; // Swahili
    const TA = 'ta'; // Tamil
    const TE = 'te'; // Telugu
    const TG = 'tg'; // Tajik
    const TH = 'th'; // Thai
    const TI = 'ti'; // Tigrinya
    const TK = 'tk'; // Turkmen
    const TL = 'tl'; // Tagalog
    const TN = 'tn'; // Tswana
    const TO = 'to'; // Tonga (Tonga Islands)
    const TR = 'tr'; // Turkish
    const TS = 'ts'; // Tsonga
    const TT = 'tt'; // Tatar
    const TW = 'tw'; // Twi
    const TY = 'ty'; // Tahitian
    const UG = 'ug'; // Uighur; Uyghur
    const UK = 'uk'; // Ukrainian
    const UR = 'ur'; // Urdu
    const UZ = 'uz'; // Uzbek
    const VE = 've'; // Venda
    const VI = 'vi'; // Vietnamese
    const VO = 'vo'; // Volapük
    const WA = 'wa'; // Walloon
    const WO = 'wo'; // Wolof
    const XH = 'xh'; // Xhosa
    const YI = 'yi'; // Yiddish
    const YO = 'yo'; // Yoruba
    const ZA = 'za'; // Zhuang; Chuang
    const ZH = 'zh'; // Chinese
    const ZU = 'zu'; // Zulu
}

/*EOF*/
