<?php

namespace DealerDirect\Generic\Category;

use DealerDirect\Generic\Repository\GenericProperties;
use DealerDirect\Generic\Repository\Locale;
use DealerDirect\Generic\Repository\Translator;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\UsesClass;
use PHPUnit\Framework\TestCase;
use ReflectionClass;

#[CoversClass(\Dealerdirect\Generic\Repository\Translator::class)]
#[CoversClass(\DealerDirect\Generic\Repository\CommonTranslator::class)]
#[CoversClass(VehicleTypeRecreationalOptions::class)]
#[CoversClass(VehicleTypeMotorOptions::class)]
#[CoversClass(VehicleTypeCarOptions::class)]

#[UsesClass(\DealerDirect\Generic\Category\AbstractEnum::class)]
#[UsesClass(\DealerDirect\Generic\Repository\GenericProperties::class)]
#[UsesClass(\DealerDirect\Generic\Repository\Locale::class)]
class VehicleTypeOptionsTest extends TestCase
{
    public function testUniqueVehicleTypeCarIds()
    {
        $carReflection = new ReflectionClass('DealerDirect\\Generic\\Category\\VehicleTypeCarOptions');
        foreach (array_count_values($carReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    public function testUniqueVehicleTypeMotorIds()
    {
        $motorReflection = new ReflectionClass('DealerDirect\\Generic\\Category\\VehicleTypeMotorOptions');
        foreach (array_count_values($motorReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }

    public function testUniqueVehicleTypeRecreationalIds()
    {
        $recreationalReflection = new ReflectionClass(
            'DealerDirect\\Generic\\Category\\VehicleTypeRecreationalOptions'
        );
        foreach (array_count_values($recreationalReflection->getConstants()) as $value) {
            $this->assertEquals($value, 1);
        }
    }


    public function testGermanAircoTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            VehicleTypeCarOptions::AIRCO,
        ]);
        $this->assertEquals($translatedValues[0], "Klimaanlage");
    }

    public function testWrongTranslationTranslation()
    {
        $locale = new Locale(Language::DE, Territory::DE);
        $genericProperties = new GenericProperties($locale, VehicleType::CAR);
        $translator = new Translator($genericProperties);
        $translatedValues = $translator->get(TranslationTypes::OPTIONS, [
            'wrong_value',
        ]);
        $this->assertEquals($translatedValues[0], "Unbekannt");
    }
}
