<?php

namespace DealerDirect\Generic\Repository;

use Dealerdirect\Generic\AbstractTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\CoversNothing;

/**
 * Tests for the Credentials class
 */
#[CoversClass(Credentials::class)]
class CredentialsTest extends AbstractTestCase
{
    public const MOCK_NAME = 'mockName';
    public const MOCK_PASSWORD = 'mockPassword';

    #[CoversNothing]
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutUserName()
    {
        $this->expectException('\\ArgumentCountError');
        $this->expectExceptionMessageMatches('/Missing argument 1|0 passed/');

        /** @noinspection PhpParamsInspection */
        new Credentials();
    }

    #[CoversNothing]
    final public function testCredentialsWillThrowExceptionWhenCalledWithoutPassword()
    {
        $this->expectException('\\ArgumentCountError');
        $this->expectExceptionMessageMatches('/Missing argument 2|1 passed/');

        /** @noinspection PhpParamsInspection */
        new Credentials(self::MOCK_NAME);
    }

    final public function testCredentialsWillReturnUsernameItHasBeenGivenWhenAskedForUsername()
    {
        $expected = self::MOCK_NAME;

        $credentials = new Credentials($expected, self::MOCK_PASSWORD);

        $actual = $credentials->getUsername();

        self::assertEquals($expected, $actual);
    }

    final public function testCredentialsWillReturnPasswordItHasBeenGivenWhenAskedForPassword()
    {
        $expected = self::MOCK_PASSWORD;

        $credentials = new Credentials(self::MOCK_NAME, $expected);

        $actual = $credentials->getPassword();

        self::assertEquals($expected, $actual);
    }
}
