<?php

namespace DealerDirect\Generic\Category;

/**
 * ISO_639-1 language codes
 */
final class Language extends AbstractEnum
{
    public const ALPHA2 = 'alpha2'; // English
    public const AA = 'aa'; // Afar
    public const AB = 'ab'; // Abkhazian
    public const AE = 'ae'; // Avestan
    public const AF = 'af'; // Afrikaans
    public const AK = 'ak'; // Akan
    public const AM = 'am'; // Amharic
    public const AN = 'an'; // Aragonese
    public const AR = 'ar'; // Arabic
    public const AS_ = 'as'; // Assamese
    public const AV = 'av'; // Avaric
    public const AY = 'ay'; // Aymara
    public const AZ = 'az'; // Azerbaijani
    public const BA = 'ba'; // Bashkir
    public const BE = 'be'; // Belarusian
    public const BG = 'bg'; // Bulgarian
    public const BH = 'bh'; // Bihari languages
    public const BI = 'bi'; // Bislama
    public const BM = 'bm'; // Bambara
    public const BN = 'bn'; // Bengali
    public const BO = 'bo'; // Tibetan
    public const BR = 'br'; // Breton
    public const BS = 'bs'; // Bosnian
    public const CA = 'ca'; // Catalan; Valencian
    public const CE = 'ce'; // Chechen
    public const CH = 'ch'; // Chamorro
    public const CO = 'co'; // Corsican
    public const CR = 'cr'; // Cree
    public const CS = 'cs'; // Czech
    public const CU = 'cu'; // Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic
    public const CV = 'cv'; // Chuvash
    public const CY = 'cy'; // Welsh
    public const DA = 'da'; // Danish
    public const DE = 'de'; // German
    public const DV = 'dv'; // Divehi; Dhivehi; Maldivian
    public const DZ = 'dz'; // Dzongkha
    public const EE = 'ee'; // Ewe
    public const EL = 'el'; // "Greek Modern (1453-)"
    public const EN = 'en'; // English
    public const EO = 'eo'; // Esperanto
    public const ES = 'es'; // Spanish; Castilian
    public const ET = 'et'; // Estonian
    public const EU = 'eu'; // Basque
    public const FA = 'fa'; // Persian
    public const FF = 'ff'; // Fulah
    public const FI = 'fi'; // Finnish
    public const FJ = 'fj'; // Fijian
    public const FO = 'fo'; // Faroese
    public const FR = 'fr'; // French
    public const FY = 'fy'; // Western Frisian
    public const GA = 'ga'; // Irish
    public const GD = 'gd'; // Gaelic; Scottish Gaelic
    public const GL = 'gl'; // Galician
    public const GN = 'gn'; // Guarani
    public const GU = 'gu'; // Gujarati
    public const GV = 'gv'; // Manx
    public const HA = 'ha'; // Hausa
    public const HE = 'he'; // Hebrew
    public const HI = 'hi'; // Hindi
    public const HO = 'ho'; // Hiri Motu
    public const HR = 'hr'; // Croatian
    public const HT = 'ht'; // Haitian; Haitian Creole
    public const HU = 'hu'; // Hungarian
    public const HY = 'hy'; // Armenian
    public const HZ = 'hz'; // Herero
    public const IA = 'ia'; // Interlingua (International Auxiliary Language Association)
    public const ID = 'id'; // Indonesian
    public const IE = 'ie'; // Interlingue; Occidental
    public const IG = 'ig'; // Igbo
    public const II = 'ii'; // Sichuan Yi; Nuosu
    public const IK = 'ik'; // Inupiaq
    public const IO = 'io'; // Ido
    public const IS = 'is'; // Icelandic
    public const IT = 'it'; // Italian
    public const IU = 'iu'; // Inuktitut
    public const JA = 'ja'; // Japanese
    public const JV = 'jv'; // Javanese
    public const KA = 'ka'; // Georgian
    public const KG = 'kg'; // Kongo
    public const KI = 'ki'; // Kikuyu; Gikuyu
    public const KJ = 'kj'; // Kuanyama; Kwanyama
    public const KK = 'kk'; // Kazakh
    public const KL = 'kl'; // Kalaallisut; Greenlandic
    public const KM = 'km'; // Central Khmer
    public const KN = 'kn'; // Kannada
    public const KO = 'ko'; // Korean
    public const KR = 'kr'; // Kanuri
    public const KS = 'ks'; // Kashmiri
    public const KU = 'ku'; // Kurdish
    public const KV = 'kv'; // Komi
    public const KW = 'kw'; // Cornish
    public const KY = 'ky'; // Kirghiz; Kyrgyz
    public const LA = 'la'; // Latin
    public const LB = 'lb'; // Luxembourgish; Letzeburgesch
    public const LG = 'lg'; // Ganda
    public const LI = 'li'; // Limburgan; Limburger; Limburgish
    public const LN = 'ln'; // Lingala
    public const LO = 'lo'; // Lao
    public const LT = 'lt'; // Lithuanian
    public const LU = 'lu'; // Luba-Katanga
    public const LV = 'lv'; // Latvian
    public const MG = 'mg'; // Malagasy
    public const MH = 'mh'; // Marshallese
    public const MI = 'mi'; // Maori
    public const MK = 'mk'; // Macedonian
    public const ML = 'ml'; // Malayalam
    public const MN = 'mn'; // Mongolian
    public const MR = 'mr'; // Marathi
    public const MS = 'ms'; // Malay
    public const MT = 'mt'; // Maltese
    public const MY = 'my'; // Burmese
    public const NA = 'na'; // Nauru
    public const NB = 'nb'; // "Bokmålconst ND = 'nd'; // "Ndebeleconst NE = 'ne'; // Nepali
    public const NG = 'ng'; // Ndonga
    public const NL = 'nl'; // Dutch; Flemish
    public const NN = 'nn'; // "Norwegian Nynorsk; Nynorskconst NO = 'no'; // Norwegian
    public const NR = 'nr'; // "Ndebele South; South Ndebele"
    public const NV = 'nv'; // Navajo; Navaho
    public const NY = 'ny'; // Chichewa; Chewa; Nyanja
    public const OC = 'oc'; // Occitan (post 1500); Provençal
    public const OJ = 'oj'; // Ojibwa
    public const OM = 'om'; // Oromo
    public const OR_ = 'or'; // Oriya
    public const OS = 'os'; // Ossetian; Ossetic
    public const PA = 'pa'; // Panjabi; Punjabi
    public const PI = 'pi'; // Pali
    public const PL = 'pl'; // Polish
    public const PS = 'ps'; // Pushto; Pashto
    public const PT = 'pt'; // Portuguese
    public const QU = 'qu'; // Quechua
    public const RM = 'rm'; // Romansh
    public const RN = 'rn'; // Rundi
    public const RO = 'ro'; // Romanian; Moldavian; Moldovan
    public const RU = 'ru'; // Russian
    public const RW = 'rw'; // Kinyarwanda
    public const SA = 'sa'; // Sanskrit
    public const SC = 'sc'; // Sardinian
    public const SD = 'sd'; // Sindhi
    public const SE = 'se'; // Northern Sami
    public const SG = 'sg'; // Sango
    public const SI = 'si'; // Sinhala; Sinhalese
    public const SK = 'sk'; // Slovak
    public const SL = 'sl'; // Slovenian
    public const SM = 'sm'; // Samoan
    public const SN = 'sn'; // Shona
    public const SO = 'so'; // Somali
    public const SQ = 'sq'; // Albanian
    public const SR = 'sr'; // Serbian
    public const SS = 'ss'; // Swati
    public const ST = 'st'; // "Sotho Southern"
    public const SU = 'su'; // Sundanese
    public const SV = 'sv'; // Swedish
    public const SW = 'sw'; // Swahili
    public const TA = 'ta'; // Tamil
    public const TE = 'te'; // Telugu
    public const TG = 'tg'; // Tajik
    public const TH = 'th'; // Thai
    public const TI = 'ti'; // Tigrinya
    public const TK = 'tk'; // Turkmen
    public const TL = 'tl'; // Tagalog
    public const TN = 'tn'; // Tswana
    public const TO = 'to'; // Tonga (Tonga Islands)
    public const TR = 'tr'; // Turkish
    public const TS = 'ts'; // Tsonga
    public const TT = 'tt'; // Tatar
    public const TW = 'tw'; // Twi
    public const TY = 'ty'; // Tahitian
    public const UG = 'ug'; // Uighur; Uyghur
    public const UK = 'uk'; // Ukrainian
    public const UR = 'ur'; // Urdu
    public const UZ = 'uz'; // Uzbek
    public const VE = 've'; // Venda
    public const VI = 'vi'; // Vietnamese
    public const VO = 'vo'; // Volapük
    public const WA = 'wa'; // Walloon
    public const WO = 'wo'; // Wolof
    public const XH = 'xh'; // Xhosa
    public const YI = 'yi'; // Yiddish
    public const YO = 'yo'; // Yoruba
    public const ZA = 'za'; // Zhuang; Chuang
    public const ZH = 'zh'; // Chinese
    public const ZU = 'zu'; // Zulu
}

/*EOF*/
