<?php

namespace DealerDirect\Generic\Category;

/**
 * Full country names for ISO 3166-1 alpha-2 territory codes.
 *
 * Please note that hard-coded values (those not using the `Territory` class)
 * are not supported (i.e. no consumer- or dealer-site is available).
 */
class CountryTerritoryCode extends AbstractEnum
{
    const AUSTRIA = 'AT';
    const BELGIUM = Territory::BE;
    const BULGARIA = 'BG';
    const CROATIA = 'HR';
    const CYPRUS = 'CY';
    const CZECH_REPUBLIC = 'CZ';
    const DENMARK = 'DK';
    const ESTONIA = 'EE';
    const FINLAND = 'FI';
    const FRANCE = Territory::FR;
    const GERMANY = Territory::DE;
    const GREECE = 'GR';
    const HUNGARY = 'HU';
    const IRELAND = 'IE';
    const ITALY = 'IT';
    const LATVIA = 'LV';
    const LITHUANIA = 'LT';
    const LUXEMBOURG = 'LU';
    const NETHERLANDS = Territory::NL;
    const NORWAY = 'NO';
    const POLAND = 'PL';
    const PORTUGAL = 'PT';
    const ROMANIA = 'RO';
    const SLOVAKIA = 'SK';
    const SLOVENIA = 'SI';
    const SPAIN = 'ES';
    const SWEDEN = Territory::SE;
    const SWITZERLAND = 'CH';
}
