<?php

namespace DealerDirect\Generic\Repository;

use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Category\Site;

class CustomerServiceInformation
{
    /**
     * Vehicle Type.
     *
     * @var
     */
    private $vehicleType;

    /**
     * CustomerServiceInformation constructor.
     *
     * @param string        $vehicleType Vehicle Type.
     */
    public function __construct($vehicleType)
    {
        $this->vehicleType = $vehicleType;
    }

    public function getCustomerServicePhoneNumber($referenceId)
    {
        if ($this->vehicleType === VehicleType::MOTOR) {
            return $this->getMotorbikePhoneNumber($referenceId);
        }
        return $this->getCarPhoneNumber($referenceId);
    }

    /**
     * Returns the phone number for car labels.
     *
     * @param string $reference Site reference
     *
     * @return string
     */
    private function getCarPhoneNumber($reference)
    {
        switch ($reference) {
            case Site::REF_CAR_BE_NL:
                return '+3216980382';
                break;
            default:
                return '+31537600027';
        }
    }

    /**
     * Returns the phone number for motorbike labels.
     *
     * @param string $reference Site reference
     *
     * @return string
     */
    private function getMotorbikePhoneNumber($reference)
    {
        switch ($reference) {
            case Site::REF_MOTO_BE:
                return '+3216980388';
                break;
            case Site::REF_MOTO_DE:
                return '+4925629993012';
                break;
            case Site::REF_SCOOTER_NL:
            default:
                return '+31532084449';
        }
    }
}
