<?php

namespace DealerDirect\Generic\Category;

/**
 * This enum contains the available types of emails that can be sent from the email-service.
 *
 * Any constants added to this class MUST be constructed as follows:
 *
 *     {ACTOR}_{SUBJECT}
 *
 * Where {ACTOR} MUST be one of:
 *
 * - Consumer (Seller of a vehicle)
 * - Dealer (Buyer of vehicles)
 *
 * The value of {SUBJECT} depends on the topic of the email in question.
 *
 * Examples:
 *
 *     CONSUMER_CANNOT_REACH_DEALER
 *     DEALER_CANNOT_BE_REACHED
 *
 * Values defined before this comment was placed do not need to be amended.
 *
 */
final class EmailType extends AbstractEnum
{
    /*/ Consumer Emails /*/
    public const BID_TO_CONSUMER = 'send-bid-to-consumer';
    public const CONFIRMATION_EMAIL = 'confirm-email';
    public const CONSUMER_CANNOT_REACH_DEALER = 'consumer-cannot-reach-dealer';
    public const CONSUMER_CONFIRM_LEAVING_SERVICE = 'consumer-confirmation-leaving-service';
    public const CONSUMER_DATA_ERROR = 'consumer-data-error';
    public const CONSUMER_DATA_SUCCESS = 'consumer-data-success';
    public const CONSUMER_PURCHASE_CANCELLED_BY_DEALER = 'consumer-purchase-cancelled-by-dealer';
    public const CONSUMER_REQUEST_CONTACT = 'consumer-request-contact';
    public const CONSUMER_REQUEST_CONTACT_FOLLOW_UP_FIRST = 'consumer-request-contact-follow-up-first';
    public const CONSUMER_REQUEST_CONTACT_FOLLOW_UP_SECOND = 'consumer-request-contact-follow-up-second';
    public const CONSUMER_SALE_CANCELLED_BY_CONSUMER = 'consumer-sale-cancelled-by-consumer';
    public const CONSUMER_SELF_SOLD = 'consumer-self-sold';
    public const CONSUMER_UNHAPPY_DEALER = 'consumer-unhappy-dealer';
    public const DEALER_RATING_SURVEY = 'dealer-rating-survey';
    public const DELIVERY_HANDLING_FIRST = 'delivery-handling-first';
    public const DELIVERY_HANDLING_MANUAL = 'delivery-handling-manual';
    public const DELIVERY_HANDLING_SECOND = 'delivery-handling-second';
    public const GOOGLE_REVIEW_INVITE = 'google-review-invite';
    public const HIGHEST_BID = 'highest-bid';
    public const HIGHEST_BID_OFFENDING = 'highest-bid-offending';
    public const REQUEST_PHONE = 'request-phone';
    public const REQUEST_PHONE_AND_PHOTO_CONFIRMATION = 'confirmation-request-photo-and-phone';
    public const REQUEST_PHONE_CONFIRMATION = 'confirmation-request-phone';
    public const REQUEST_PHOTO = 'request-photo';
    public const REQUEST_PHOTO_REMINDER = 'request-photo-reminder';
    public const SALE_AGREEMENT = 'sale-agreement';
    public const TRAIN_TICKET_REFUND = 'train-ticket-refund';
    public const TRUSTPILOT_INVITE = 'trustpilot';

    /*/ Dealer Emails /*/
    public const DEALER_BID_TO_LOW = 'dealer-bid-too-low';
    public const DEALER_CANNOT_BE_REACHED = 'dealer-cannot-be-reached';
    public const DEALER_COMPLIMENT_FROM_CONSUMER = 'dealer-compliment-from-consumer';
    public const DEALER_INFORM_CONSUMER_SELF_SOLD = 'dealer-inform-consumer-self-sold';
    public const DEALER_ONBOARDING_ACTIVATION = 'dealer-onboarding-activation';
    public const DEALER_ONBOARDING_FOLLOW_UP_FIRST = 'dealer-onboarding-follow-up-first';
    public const DEALER_ONBOARDING_FOLLOW_UP_FOURTH = 'dealer-onboarding-follow-up-fourth';
    public const DEALER_ONBOARDING_FOLLOW_UP_SECOND = 'dealer-onboarding-follow-up-second';
    public const DEALER_ONBOARDING_FOLLOW_UP_THIRD = 'dealer-onboarding-follow-up-third';
    public const DEALER_OUTBID = 'outbid';
    public const DEALER_REGISTRATION = 'dealer-registration';
    public const DEALER_REQUEST_DELIVERY_CONFIRMATION = 'dealer-request-delivery-confirmation';
    public const PURCHASE_AGREEMENT = 'purchase-agreement';
    public const SEARCH_RESULT = 'search-result';
    public const SUGGEST_LOT = 'suggest-lot';

    /*/ Lead nurturing /*/
    public const LEAD_NURTURE_ASKING_PRICE = 'lead-nurture-asking-price';
    public const LEAD_NURTURE_ASKING_PRICE_SECOND = 'lead-nurture-asking-price-second';
    public const LEAD_NURTURE_CURIOUS = 'lead-nurture-curious';
    public const LEAD_NURTURE_MORE_TIME = 'lead-nurture-more-time';
    public const LEAD_NURTURE_VALUATION = 'lead-nurture-valuation';
}
