<?php

use DealerDirect\Generic\Category\Upholstery;
use DealerDirect\Generic\Category\VehicleType;
use DealerDirect\Generic\Category\VehicleTypeCarBodyType;
use DealerDirect\Generic\Category\VehicleTypeMotorBodyType;
use DealerDirect\Generic\Category\VehicleTypeCarCondition;
use DealerDirect\Generic\Category\VehicleTypeMotorCondition;
use DealerDirect\Generic\Category\VehicleTypeCarTransmission;
use DealerDirect\Generic\Category\VehicleTypeMotorTransmission;

return [
    'default' => 'Inconnu',
    VehicleType::CAR => [
        'bodytype' => [
            VehicleTypeCarBodyType::UNKNOWN => 'Inconnu',
            VehicleTypeCarBodyType::THREE_DOOR_HATCHBACK => 'Hatchback (bicorps) 3-portes',
            VehicleTypeCarBodyType::FOUR_DOOR_SALOON => 'Sedan 4-portes',
            VehicleTypeCarBodyType::FIVE_DOOR_HATCHBACK => 'Hatchback (bicorps) 5-portes',
            VehicleTypeCarBodyType::MPV => 'Monovolume',
            VehicleTypeCarBodyType::PASSENGER_BUS => 'Minibus',
            VehicleTypeCarBodyType::SUV_CROSSOVER => 'SUV',
            VehicleTypeCarBodyType::STATION => 'Break',
            VehicleTypeCarBodyType::CONVERTIBLE => 'Cabriolet',
            VehicleTypeCarBodyType::COUPE => 'Coupé',
            VehicleTypeCarBodyType::CROSS_COUNTRY => 'Voiture tout terrain',
            VehicleTypeCarBodyType::VAN_SINGLE_CABIN => 'Camionnette',
            VehicleTypeCarBodyType::VAN_DOUBLE_CABIN => 'Camionnette double cabine',
            VehicleTypeCarBodyType::TRUCK => 'Camion',
            VehicleTypeCarBodyType::PICKUP => 'Pick-up',
            VehicleTypeCarBodyType::CAMPER => 'Camping car',
            VehicleTypeCarBodyType::CARAVAN => 'Caravane',
            VehicleTypeCarBodyType::TRAILER => 'Remorque',
            VehicleTypeCarBodyType::FOLDING_CARAVAN => 'Caravane pliante',
            VehicleTypeCarBodyType::MICROCAR => 'Voiture sans permis',
            // DEPRECATED
            // VehicleTypeCarBodyType::CC_CONVERTIBLE_COUPE => 'CC: Cabriolet & Coupé',
            // VehicleTypeCarBodyType::TWO_DOOR_HATCHBACK => '2-portes hatchback',
            // VehicleTypeCarBodyType::TWO_DOOR_SALOON => '2-portes sedan',
        ],
        'condition' => [
            VehicleTypeCarCondition::UNKNOWN => 'Inconnu',
            VehicleTypeCarCondition::AS_NEW => 'Nouvelle condition',
            VehicleTypeCarCondition::GOOD => 'Bon',
            VehicleTypeCarCondition::AVERAGE => 'Moyen',
            VehicleTypeCarCondition::BAD => 'Mauvais'
        ],
        'transmission' => [
            VehicleTypeCarTransmission::UNKNOWN => 'Inconnu',
            VehicleTypeCarTransmission::MANUAL => 'Manuelle',
            VehicleTypeCarTransmission::AUTOMATIC => 'Automatique',
            VehicleTypeCarTransmission::SEMI_AUTOMATIC => 'Semi-automatique'
        ],
        'upholstery' => [
            Upholstery::UNKNOWN => 'Inconnu',
            Upholstery::ALCANTARA => 'Alcantara',
            Upholstery::CLOTH => 'Tissu',
            Upholstery::SEMI_LEATHER => 'Semi-cuir',
            Upholstery::LEATHER => 'Cuir',
            Upholstery::LEATHERETTE => 'Skaï'
        ]
    ],
    VehicleType::MOTOR => [
        'bodytype' => [
            VehicleTypeMotorBodyType::UNKNOWN => 'Inconnu',
            VehicleTypeMotorBodyType::ALL_ROAD => 'ATV',
            VehicleTypeMotorBodyType::CUSTOM => 'Custom',
            VehicleTypeMotorBodyType::CROSS => 'Motocross',
            VehicleTypeMotorBodyType::ENDURO => 'Enduro',
            VehicleTypeMotorBodyType::NAKED => 'Roadster',
            VehicleTypeMotorBodyType::RACE => 'Compétition',
            VehicleTypeMotorBodyType::SUPER_SPORT => 'Supersportive',
            VehicleTypeMotorBodyType::SPORT_TOURING => 'Sportive-routière',
            VehicleTypeMotorBodyType::MOTOR_SCOOTER => 'Scooter',
            VehicleTypeMotorBodyType::SUPER_MOTO => 'Supermotard',
            VehicleTypeMotorBodyType::TOURING => 'Routière',
            VehicleTypeMotorBodyType::SIDE_CAR => 'Side-car',
            VehicleTypeMotorBodyType::TRIKE => 'Trike',
            VehicleTypeMotorBodyType::CLASSIC => 'Classic/Collection',
            VehicleTypeMotorBodyType::QUAD => 'Quad',
            VehicleTypeMotorBodyType::MOPED_25 => 'Vélomoteur 25',
            VehicleTypeMotorBodyType::MOPED_45 => 'Vélomoteur 45',
            VehicleTypeMotorBodyType::TRIAL => 'Trial',
            VehicleTypeMotorBodyType::MICROCAR => 'Voiture sans permis',
        ],
        'condition' => [
            VehicleTypeMotorCondition::UNKNOWN => 'Inconnu',
            VehicleTypeMotorCondition::AS_NEW => 'Nouvelle condition',
            VehicleTypeMotorCondition::GOOD => 'Bon',
            VehicleTypeMotorCondition::AVERAGE => 'Moyen',
            VehicleTypeMotorCondition::POOR => 'Médiocre',
            VehicleTypeMotorCondition::BAD => 'Mauvais'
        ],
        'transmission' => [
            VehicleTypeMotorTransmission::UNKNOWN => 'Inconnu',
            VehicleTypeMotorTransmission::MANUAL => 'Manuelle',
            VehicleTypeMotorTransmission::SEMI_AUTOMATIC => 'Semi-automatique',
            VehicleTypeMotorTransmission::AUTOMATIC => 'Automatique'
        ]
    ]
];
